/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.RenameUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.ReplaceEdit;

public interface IChangeValidator {
    public static final String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.ext.ide.ui";
    public static final String LIST_ENTRY_PREFIX = "<listEntry";
    public static final String LIST_ATTRIBUTE_PREFIX = "<listAttribute";
    public static final String S32DS_VARIABLE_PREFIX = "${S32DS_";
    public static final String REGEX_FOR_NAMED_VALUE = "=\"[^\"]*?%s[^\"]*?\"";
    public static final String REGEX_FOR_VALUE_WITHOUT_NAME = ">.*%s.*<";

    default public boolean skipChange(List<AttributeLine> affectedAttributes, IDocument doc, ReplaceEdit re) {
        block8: {
            List<AttributeLine> attributesWithFoundValue;
            String line;
            block9: {
                String oldName;
                int indexOfOldNameInLine;
                int lin;
                block7: {
                    if (affectedAttributes == null || affectedAttributes.isEmpty()) {
                        return true;
                    }
                    int pos = re.getOffset();
                    lin = doc.getLineOfOffset(pos);
                    int off = doc.getLineOffset(lin);
                    int len = doc.getLineLength(lin);
                    indexOfOldNameInLine = pos - off;
                    line = doc.get(off, len);
                    oldName = doc.get(pos, re.getLength());
                    if (RenameUtils.isProjectName((String)line, (String)oldName, (int)indexOfOldNameInLine) && IChangeValidator.isLocalPathOrName(line, indexOfOldNameInLine, oldName.length())) break block7;
                    return true;
                }
                try {
                    line = line.trim();
                    attributesWithFoundValue = IChangeValidator.getAttributesWithFoundValue(line, oldName, affectedAttributes, indexOfOldNameInLine);
                    if (attributesWithFoundValue == null || attributesWithFoundValue.isEmpty()) break block8;
                    if (!line.startsWith(LIST_ENTRY_PREFIX)) break block9;
                    int i = lin - 1;
                    while (i > 0) {
                        String s = doc.get(doc.getLineOffset(i), doc.getLineLength(i)).trim();
                        if (s.startsWith(LIST_ATTRIBUTE_PREFIX)) {
                            return !IChangeValidator.containsKey(s, attributesWithFoundValue);
                        }
                        --i;
                    }
                    return true;
                }
                catch (BadLocationException e) {
                    Status status = new Status(4, BUNDLE_SYMBOLIC_NAME, e.getMessage(), (Throwable)e);
                    ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                    return true;
                }
            }
            return !IChangeValidator.containsKey(line, attributesWithFoundValue);
        }
        return true;
    }

    public static List<AttributeLine> getAttributesWithFoundValue(String line, String oldName, List<AttributeLine> affectedAttributes, int indexOfName) {
        ArrayList<AttributeLine> attributesWithFoundValue = new ArrayList<AttributeLine>();
        String valuePatternUsedWithName = null;
        block0: for (AttributeLine attrLine : affectedAttributes) {
            if (valuePatternUsedWithName == null) {
                for (String valuePattern : attrLine.valuePatterns) {
                    Matcher matcher = Pattern.compile(String.format(valuePattern, oldName)).matcher(line);
                    if (!matcher.find() || matcher.end() <= indexOfName || matcher.start() >= indexOfName) continue;
                    attributesWithFoundValue.add(attrLine);
                    valuePatternUsedWithName = valuePattern;
                    continue block0;
                }
                continue;
            }
            if (!attrLine.valuePatterns.contains(valuePatternUsedWithName)) continue;
            attributesWithFoundValue.add(attrLine);
        }
        return attributesWithFoundValue;
    }

    public static boolean containsKey(String line, List<AttributeLine> affectedAttributes) {
        return affectedAttributes.stream().anyMatch(attr -> line.contains(attr.keyPattern) && (attr.attributeName == null || Pattern.compile(attr.attributeName).matcher(line).find()));
    }

    public static boolean isLocalPathOrName(String line, int indexOfName, int nameLength) {
        int indexOfNearestQuotes1 = line.substring(0, indexOfName).lastIndexOf("\"");
        int indexOfNearestQuotes2 = line.indexOf("\"", indexOfName + nameLength);
        return indexOfNearestQuotes1 == -1 || indexOfNearestQuotes2 == -1 || !line.substring(indexOfNearestQuotes1, indexOfNearestQuotes2).contains(S32DS_VARIABLE_PREFIX);
    }

    public static class AttributeLine {
        String keyPattern;
        List<String> valuePatterns;
        String attributeName;

        public AttributeLine(String keyPattern, List<String> valuePatterns, String attributeName) {
            this.keyPattern = keyPattern;
            this.valuePatterns = valuePatterns;
            this.attributeName = attributeName;
        }
    }
}

