/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker;

import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.AToolChainFPChecker;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

class GHSToolChainFPCheckerLib
extends AToolChainFPChecker {
    private static final String GHS_CC_COMPILER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.static_library.toolchain.cc_compiler.target_floating_point.floating_point_mode";
    private static final String GHS_CC_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.static_library.toolchain.cc_compiler.target_floating_point.floating_point_mode.hardware_single_software_double";
    private static final String GHS_CX_COMPILER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.static_library.toolchain.cx_compiler.target_floating_point.floating_point_mode";
    private static final String GHS_CX_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.static_library.toolchain.cx_compiler.target_floating_point.floating_point_mode.hardware_single_software_double";
    private static final String GHS_CC_LINKER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.static_library.toolchain.cc_linker.target_floating_point.floating_point_mode";
    private static final String GHS_CC_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.static_library.toolchain.cc_linker.target_floating_point.floating_point_mode.hardware_single_software_double";
    private static final String GHS_CX_LINKER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.static_library.toolchain.cx_linker.target_floating_point.floating_point_mode";
    private static final String GHS_CX_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.static_library.toolchain.cx_linker.target_floating_point.floating_point_mode.hardware_single_software_double";
    private IGHSTargetFPCoProcessorOptionsChecker ghsTargetCFPCoProcessorOptionsChecker;
    private IGHSTargetFPCoProcessorOptionsChecker ghsTargetCppFPCoProcessorOptionsChecker;

    GHSToolChainFPCheckerLib() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkToolChainFPOptionsSet(IToolChain tc) {
        try {
            ITool[] tools = tc.getTools();
            int toolsCount = tools.length;
            int i = 0;
            while (true) {
                if (i >= toolsCount) {
                    return true;
                }
                ITool tool = tools[i];
                if (!this.checkOptionValue(tool.getOptionBySuperClassId(GHS_CC_COMPILER_FP_COPROCESSOR_OPTION_ID), GHS_CC_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID)) {
                    return false;
                }
                if (!this.getGHSTargetToolChainFPChecker(tc).checkFPCoProcessorOptions(tc, tool)) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            SDKSupportPlugin.log(ce.getStatus());
        }
        return true;
    }

    private IGHSTargetFPCoProcessorOptionsChecker getGHSTargetToolChainFPChecker(IToolChain tc) throws CoreException {
        if (this.isCppProject(tc) != null) {
            if (this.ghsTargetCppFPCoProcessorOptionsChecker == null) {
                this.ghsTargetCppFPCoProcessorOptionsChecker = new GHSTargetCppFPCoProcessorOptionsChecker();
            }
            return this.ghsTargetCppFPCoProcessorOptionsChecker;
        }
        if (this.ghsTargetCFPCoProcessorOptionsChecker == null) {
            this.ghsTargetCFPCoProcessorOptionsChecker = new GHSTargetCFPCoProcessorOptionsChecker();
        }
        return this.ghsTargetCFPCoProcessorOptionsChecker;
    }

    private IProjectNature isCppProject(IToolChain tc) throws CoreException {
        IProject project;
        IResource owner;
        IProjectNature nature = null;
        IConfiguration parent = tc.getParent();
        if (parent != null && (owner = parent.getManagedProject().getOwner()) != null && (project = owner.getProject()) != null) {
            nature = project.getNature("org.eclipse.cdt.core.ccnature");
        }
        return nature;
    }

    class GHSTargetCFPCoProcessorOptionsChecker
    implements IGHSTargetFPCoProcessorOptionsChecker {
        GHSTargetCFPCoProcessorOptionsChecker() {
        }

        @Override
        public boolean checkFPCoProcessorOptions(IToolChain tc, ITool tool) {
            return GHSToolChainFPCheckerLib.this.checkOptionValue(tool.getOptionBySuperClassId(GHSToolChainFPCheckerLib.GHS_CC_LINKER_FP_COPROCESSOR_OPTION_ID), GHSToolChainFPCheckerLib.GHS_CC_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID);
        }
    }

    class GHSTargetCppFPCoProcessorOptionsChecker
    implements IGHSTargetFPCoProcessorOptionsChecker {
        GHSTargetCppFPCoProcessorOptionsChecker() {
        }

        @Override
        public boolean checkFPCoProcessorOptions(IToolChain tc, ITool tool) {
            boolean isCheckPassed = GHSToolChainFPCheckerLib.this.checkOptionValue(tool.getOptionBySuperClassId(GHSToolChainFPCheckerLib.GHS_CX_COMPILER_FP_COPROCESSOR_OPTION_ID), GHSToolChainFPCheckerLib.GHS_CX_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID);
            if (isCheckPassed) {
                isCheckPassed = GHSToolChainFPCheckerLib.this.checkOptionValue(tool.getOptionBySuperClassId(GHSToolChainFPCheckerLib.GHS_CX_LINKER_FP_COPROCESSOR_OPTION_ID), GHSToolChainFPCheckerLib.GHS_CX_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID);
            }
            return isCheckPassed;
        }
    }

    static interface IGHSTargetFPCoProcessorOptionsChecker {
        public boolean checkFPCoProcessorOptions(IToolChain var1, ITool var2);
    }
}

