/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKPageContentProvider;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKPageLabelProvider;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class SDKAttachConfigurationsDialog
extends TitleAreaDialog {
    private final List<ISDK> selectedSDKs;
    private final IProject project;
    private final Map<String, Boolean[]> selectedConfigs;
    private Shell shell;
    private TableViewer tableViewer;

    public SDKAttachConfigurationsDialog(Shell parentShell, List<ISDK> selectedSDKs, IProject project, Map<String, Boolean[]> selectedConfigs) {
        super(parentShell);
        this.selectedSDKs = selectedSDKs;
        this.project = project;
        this.selectedConfigs = selectedConfigs;
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.SDKAttachConfigurationsDialog_text);
        this.setMessage(Messages.SDKAttachConfigurationsDialog_message);
        Composite body = new Composite(content, 0);
        body.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().applyTo((Control)body);
        this.tableViewer = new TableViewer(this.createTable(body, 0));
        this.setupTable(body);
        this.setHelpAvailable(false);
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.shell = shell;
        this.shell.setText(Messages.SDKAttachConfigurationsDialog_title);
    }

    private void setupTable(Composite body) {
        TableViewerColumn name = new TableViewerColumn(this.tableViewer, 0);
        name.getColumn().setText(Messages.SDKAttachConfigurationsDialog_name_column_title);
        name.getColumn().setWidth(150);
        name.setLabelProvider((CellLabelProvider)new SDKPageLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((ISDK)cell.getElement()).getBriefInfo());
            }
        });
        TableViewerColumn[] cols = null;
        if (this.project != null) {
            IConfiguration[] cfgs = ManagedBuildManager.getBuildInfo((IResource)this.project).getManagedProject().getConfigurations();
            cols = new TableViewerColumn[cfgs.length];
            int i = 0;
            while (i < cfgs.length) {
                String cname = cfgs[i].getName();
                cols[i] = new TableViewerColumn(this.tableViewer, 0);
                cols[i].getColumn().setText(cname);
                cols[i].getColumn().setToolTipText(cname);
                cols[i].getColumn().setWidth(50);
                cols[i].setLabelProvider(SDKPageLabelProvider.getCfgLabelProvider(i, this.selectedConfigs, cfgs.length, cfgs[i]));
                cols[i].setEditingSupport(SDKPageLabelProvider.getCfgEditingSupport((ColumnViewer)this.tableViewer, i, this.selectedConfigs));
                ++i;
            }
        }
        TableColumnLayout tableLayout = new TableColumnLayout();
        body.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)name.getColumn(), (ColumnLayoutData)new ColumnWeightData(150));
        if (cols != null) {
            TableViewerColumn[] tableViewerColumnArray = cols;
            int n = cols.length;
            int n2 = 0;
            while (n2 < n) {
                TableViewerColumn col = tableViewerColumnArray[n2];
                tableLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
                ++n2;
            }
        }
        this.tableViewer.setContentProvider((IContentProvider)new SDKPageContentProvider());
        this.tableViewer.setInput(this.selectedSDKs);
    }

    private Table createTable(Composite composite, int style) {
        Table t = new Table(composite, 0x10A00 | style);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = t.getItemHeight() * 7;
        t.setLayoutData((Object)gd);
        return t;
    }
}

