/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.sdkexplorer;

import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.SDKObserver;
import com.freescale.s32ds.cross.sdk.ui.sdkexplorer.SDKExplorerContentProvider;
import com.freescale.s32ds.cross.sdk.ui.sdkexplorer.SDKExplorerDragSourceListener;
import com.freescale.s32ds.cross.sdk.ui.sdkexplorer.SDKExplorerLabelProvider;
import com.freescale.s32ds.ui.dndexplorer.ADnDExplorer;
import com.freescale.s32ds.ui.dndexplorer.ADragSourceListener;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IStructureDeclaration;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class SDKExplorer
extends ADnDExplorer
implements SDKObserver {
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.addDoubleClickListener(new SDKExplorerDoubleClickListener());
        SDKUtils.addListener(this);
    }

    public void dispose() {
        ISelectionService service = this.getSite().getWorkbenchWindow().getSelectionService();
        service.removeSelectionListener((ISelectionListener)this);
        SDKUtils.removeListener(this);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IProject selectionProject = this.getActiveProjectFromSelection(selection);
        if (selectionProject == null || this.checkEvent(part, selectionProject)) {
            this.updateTree(selectionProject);
        }
    }

    @Override
    public void change() {
        this.getFilteredTree().getDisplay().asyncExec(() -> {
            TreeViewer treeViewer = this.getTreeViewer();
            treeViewer.setInput((Object)this.getData());
            Object[] expanded = treeViewer.getExpandedElements();
            treeViewer.setExpandedElements(expanded);
        });
    }

    protected ICProject getData() {
        return SDKSupportPlugin.findCProject(this.project);
    }

    protected SDKExplorerContentProvider newContentProvider() {
        return new SDKExplorerContentProvider(this.getTreeViewer());
    }

    protected SDKExplorerLabelProvider newLabelProvider() {
        return new SDKExplorerLabelProvider();
    }

    protected ADragSourceListener newDragSourceListener() {
        return new SDKExplorerDragSourceListener((AbstractTreeViewer)this.getTreeViewer(), this.getSite());
    }

    private boolean checkEvent(IWorkbenchPart part, IProject selectionProject) {
        return (selectionProject != this.project || part instanceof SDKExplorer) && selectionProject != null;
    }

    class SDKExplorerDoubleClickListener
    implements IDoubleClickListener {
        SDKExplorerDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            Object data = ((IStructuredSelection)SDKExplorer.this.getTreeViewer().getSelection()).getFirstElement();
            try {
                int offset = 0;
                String fname = null;
                ITextEditor textEditor = null;
                if (data instanceof ITranslationUnit) {
                    ITranslationUnit translationUnit = ((ISourceReference)data).getTranslationUnit();
                    fname = translationUnit.getElementName();
                    textEditor = SDKExplorer.this.getTextEditor(translationUnit);
                } else {
                    ISourceReference sRef = null;
                    if (data instanceof ISourceReference) {
                        sRef = (ISourceReference)data;
                        if (data instanceof IFunctionDeclaration) {
                            fname = ((IFunctionDeclaration)data).getElementName();
                        } else if (data instanceof IMacro) {
                            fname = ((IMacro)data).getElementName();
                        } else if (data instanceof IStructureDeclaration) {
                            fname = ((IStructureDeclaration)data).getElementName();
                        } else if (data instanceof IEnumeration) {
                            fname = ((IEnumeration)data).getElementName();
                        } else if (data instanceof IEnumerator) {
                            fname = ((IEnumerator)data).getElementName();
                        } else if (data instanceof INamespace) {
                            fname = ((INamespace)data).getElementName();
                        }
                        if (sRef != null && fname != null) {
                            String source = sRef.getSource();
                            ISourceRange sr = sRef.getSourceRange();
                            offset = source != null ? sr.getStartPos() + source.indexOf(fname) : 0;
                            textEditor = SDKExplorer.this.getTextEditor(sRef.getTranslationUnit());
                        }
                    }
                }
                if (textEditor != null) {
                    textEditor.selectAndReveal(offset, fname.length());
                }
            }
            catch (Exception e) {
                SDKSupportPlugin.error(e);
            }
        }
    }
}

