/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.sdkexplorer;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.ExtendedIncludeRef;
import com.freescale.s32ds.cross.sdk.internal.IExtendedIncludeReference;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import com.freescale.s32ds.ui.dndexplorer.ADnDExplorerContentProvider;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.dialogs.PatternFilter;

public class SDKExplorerContentProvider
extends ADnDExplorerContentProvider {
    private static final Object[] EMPTY = new Object[0];
    private ICProject project;
    private final Map<RefKey, IExtendedIncludeReference> extRefMap = new HashMap<RefKey, IExtendedIncludeReference>();

    public SDKExplorerContentProvider(TreeViewer viewer) {
        super(viewer);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.project = (ICProject)newInput;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ICProject) {
            ICProject p = (ICProject)parentElement;
            List<ISDK> sdks = SDKAttach.getAttached(p.getProject());
            return sdks != null ? sdks.toArray() : EMPTY;
        }
        if (parentElement instanceof ISDK) {
            ArrayList<ICElement> children = new ArrayList<ICElement>();
            ISDK sdk = (ISDK)parentElement;
            String toolchainId = ManagedBuildManager.getBuildInfo((IResource)this.project.getProject()).getDefaultConfiguration().getToolChain().getBaseId();
            List<IExtendedPath> headers = Arrays.asList(sdk.getHeaders(toolchainId));
            IPath path = SDKSupportPlugin.getEclipsePath(sdk);
            try {
                IIncludeReference[] incRefs = this.project.getIncludeReferences();
                ArrayList<IIncludeReference> sdkIncRefs = new ArrayList<IIncludeReference>();
                IIncludeReference[] iIncludeReferenceArray = incRefs;
                int n = incRefs.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean isFiltered;
                    IIncludeReference incRef = iIncludeReferenceArray[n2];
                    if (path.isPrefixOf(incRef.getPath()) && (isFiltered = this.isSelectedInSDK((ICElement)incRef, headers))) {
                        sdkIncRefs.add(incRef);
                    }
                    ++n2;
                }
                if (!sdkIncRefs.isEmpty()) {
                    HashMap<String, IExtendedIncludeReference> segments = new HashMap<String, IExtendedIncludeReference>();
                    for (IIncludeReference ref : sdkIncRefs) {
                        this.processIncludeReference(ref, path, children, segments, (lambdaPath, lambdaRef) -> {
                            RefKey key = RefKey.create(lambdaPath, lambdaRef);
                            IExtendedIncludeReference extRef = this.extRefMap.get(key);
                            if (extRef == null) {
                                extRef = new ExtendedIncludeRef(lambdaPath, lambdaRef);
                                this.extRefMap.put(key, extRef);
                            }
                            return extRef;
                        });
                    }
                }
            }
            catch (CModelException e) {
                SDKSupportPlugin.error(e);
            }
            return this.sortToArray(children);
        }
        if (parentElement instanceof IExtendedIncludeReference) {
            return this.getIncRefChildren((IExtendedIncludeReference)parentElement);
        }
        if (parentElement instanceof IParent) {
            IParent parent = (IParent)parentElement;
            ArrayList<IMethodDeclaration> children = new ArrayList<IMethodDeclaration>();
            try {
                children.addAll(parent.getChildrenOfType(79));
                children.addAll(parent.getChildrenOfType(61));
                children.addAll(parent.getChildrenOfType(65));
                children.addAll(parent.getChildrenOfType(83));
                children.addAll(parent.getChildrenOfType(82));
                List methods = parent.getChildrenOfType(70);
                methods.addAll(parent.getChildrenOfType(71));
                for (ICElement m : methods) {
                    IMethodDeclaration md = (IMethodDeclaration)m;
                    if (md.isConstructor() || md.isDestructor() || md.getVisibility() != ASTAccessVisibility.PUBLIC) continue;
                    children.add(md);
                }
                children.addAll(parent.getChildrenOfType(74));
                children.addAll(parent.getChildrenOfType(73));
                children.addAll(parent.getChildrenOfType(89));
                children.addAll(parent.getChildrenOfType(88));
                children.addAll(parent.getChildrenOfType(63));
                children.addAll(parent.getChildrenOfType(81));
            }
            catch (CModelException e) {
                SDKSupportPlugin.error(e);
            }
            return children.toArray();
        }
        return EMPTY;
    }

    private boolean isSelectedInSDK(ICElement element, List<IExtendedPath> headers) {
        boolean isMatched = false;
        if (element instanceof ITranslationUnit) {
            ITranslationUnit tu = (ITranslationUnit)element;
            if (headers.contains(tu.getPath())) {
                isMatched = true;
            }
        } else if (element instanceof IIncludeReference) {
            IIncludeReference ir = (IIncludeReference)element;
            try {
                ICElement[] iCElementArray = ir.getChildren();
                int n = iCElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElement child = iCElementArray[n2];
                    if (!(child instanceof ITranslationUnit) || !(isMatched = this.isSelectedInSDK(child, headers))) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            catch (CModelException cModelException) {}
        }
        return isMatched;
    }

    private List<ICElement> safeGetChildrenOfType(IParent parent, int element) {
        try {
            return parent.getChildrenOfType(element);
        }
        catch (CModelException e) {
            SDKSupportPlugin.error(e);
            return null;
        }
    }

    public boolean hasChildren(Object element) {
        List<Object> childs = Arrays.asList(this.getChildren(element));
        List filters = Arrays.stream(this.getViewer().getFilters()).filter(filter -> !(filter instanceof PatternFilter)).collect(Collectors.toList());
        if (filters.isEmpty()) {
            return childs.size() > 0;
        }
        Integer childFilterCounter = 0;
        for (Object child : childs) {
            int passFilterCount = 0;
            for (ViewerFilter filter2 : filters) {
                if (!filter2.select((Viewer)this.getViewer(), null, child)) continue;
                ++passFilterCount;
            }
            if (passFilterCount != filters.size()) continue;
            childFilterCounter = childFilterCounter + 1;
        }
        return childFilterCounter > 0;
    }

    private ICElement[] getIncRefChildren(IIncludeReference incRef) {
        return this.getRefChildren(incRef, new IRefWrapper<IIncludeReference>(){

            @Override
            public IIncludeReference create(IPath base, ICElement parent) {
                IIncludeReference ref = (IIncludeReference)parent;
                RefKey key = RefKey.create(base, ref);
                IExtendedIncludeReference extRef = (IExtendedIncludeReference)SDKExplorerContentProvider.this.extRefMap.get(key);
                if (extRef == null) {
                    extRef = new ExtendedIncludeRef(base, ref);
                    SDKExplorerContentProvider.this.extRefMap.put(key, extRef);
                }
                return extRef;
            }

            @Override
            public boolean acceptRef(ICElement ref) {
                return ref instanceof IExtendedIncludeReference && SDKExplorerContentProvider.this.contains(ref, SDKSupportPlugin.headersMatcher);
            }

            @Override
            public boolean accept(ICElement element) {
                return element instanceof ITranslationUnit && ((ITranslationUnit)element).isHeaderUnit();
            }
        });
    }

    private <R extends IParent & ICElement> ICElement[] getRefChildren(R baseRef, final IRefWrapper<R> wrapper) {
        ArrayList<ICElement> refChildren = new ArrayList<ICElement>();
        try {
            IPath path = ((ICElement)baseRef).getPath();
            HashMap<String, IExtendedIncludeReference> segments = new HashMap<String, IExtendedIncludeReference>();
            ICElement[] iCElementArray = baseRef.getChildren();
            int n = iCElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement element = iCElementArray[n2];
                if (wrapper.acceptRef(element)) {
                    IIncludeReference ref = ((IExtendedIncludeReference)element).get();
                    this.processIncludeReference(ref, path, refChildren, segments, new IExtendedInculdeReferenceCreator(){

                        @Override
                        public IExtendedIncludeReference create(IPath path, IIncludeReference ref) {
                            return (IExtendedIncludeReference)wrapper.create(path, (ICElement)ref);
                        }
                    });
                } else if (wrapper.accept(element)) {
                    refChildren.add(element);
                }
                ++n2;
            }
        }
        catch (CModelException e) {
            SDKSupportPlugin.error(e);
        }
        return this.sortToArray(refChildren);
    }

    private <T extends ICElement> boolean contains(T ref, final PathMatcher matcher) {
        final boolean[] found = new boolean[1];
        Path root = Paths.get(ref.getPath().toOSString(), new String[0]);
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (matcher.matches(file)) {
                        found[0] = true;
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            SDKSupportPlugin.error(e);
        }
        return found[0];
    }

    private ICElement[] sortToArray(List<ICElement> list) {
        if (!list.isEmpty()) {
            Collections.sort(list, new Comparator<ICElement>(){

                @Override
                public int compare(ICElement o1, ICElement o2) {
                    boolean isDir1 = o1.getPath().toFile().isDirectory();
                    boolean isDir2 = o2.getPath().toFile().isDirectory();
                    String path1 = o1.getPath().toString();
                    String path2 = o2.getPath().toString();
                    if (isDir1 && isDir2 || !isDir1 && !isDir2) {
                        return path1.compareTo(path2);
                    }
                    return isDir1 ? -1 : 1;
                }
            });
        }
        return list.toArray(new ICElement[list.size()]);
    }

    private void processIncludeReference(IIncludeReference ref, IPath path, List<ICElement> children, Map<String, IExtendedIncludeReference> segments, IExtendedInculdeReferenceCreator creator) throws CModelException {
        IExtendedIncludeReference extRef;
        if (ref.getPath().equals((Object)path)) {
            children.addAll(Arrays.asList(this.getIncRefChildren(ref)));
            return;
        }
        String first = ref.getPath().makeRelativeTo(path).segment(0);
        if (!segments.containsKey(first)) {
            extRef = creator.create(path, ref);
            segments.put(first, extRef);
            children.add((ICElement)extRef);
        }
        extRef = segments.get(first);
        IPath parent = extRef.getPath();
        if (ref.getPath().equals((Object)parent)) {
            extRef.addAll(ref.getChildren());
        } else {
            IExtendedIncludeReference child = creator.create(parent, ref);
            extRef.add((ICElement)child);
        }
    }

    static interface IExtendedInculdeReferenceCreator {
        public IExtendedIncludeReference create(IPath var1, IIncludeReference var2);
    }

    static interface IRefWrapper<R extends IParent & ICElement> {
        public R create(IPath var1, ICElement var2);

        public boolean acceptRef(ICElement var1);

        public boolean accept(ICElement var1);
    }

    static class RefKey {
        final IPath base;
        final IIncludeReference ref;

        public static RefKey create(IPath base, IIncludeReference ref) {
            return new RefKey(base, ref);
        }

        RefKey(IPath base, IIncludeReference ref) {
            this.base = base;
            this.ref = ref;
        }

        public int hashCode() {
            return 31 * this.base.hashCode() + 13 * this.ref.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof RefKey)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            RefKey other = (RefKey)obj;
            return this.base.equals((Object)other.base) && this.ref.equals(other.ref);
        }
    }
}

