/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model;

import com.freescale.s32ds.cross.core.model.EditorType;
import com.freescale.s32ds.cross.core.model.IParameterHandler;
import com.freescale.s32ds.cross.core.model.ModelUtil;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.ValueType;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;

public class DefaultParameterHandler
implements IParameterHandler {
    @Override
    public boolean isEnabled(String tag, AbstractContext context) {
        ParameterType parameterType = context.getRegistry().getParameterType(tag);
        return parameterType != null && EditorType.LABEL != parameterType.getEditorType();
    }

    @Override
    public ChangeResult onEdit(String tag, Object newValue, AbstractContext context) {
        return new ChangeResult(true);
    }

    @Override
    public ChangeResult onInit(String tag, Object newValue, AbstractContext context) {
        return new ChangeResult(true);
    }

    @Override
    public Object parseValue(String tag, String value, AbstractContext context) {
        ParameterType parameterType = context.getRegistry().getParameterType(tag);
        if (ValueType.BOOLEAN == parameterType.getValueType()) {
            return ModelUtil.parseBoolean(value);
        }
        if (ValueType.INTEGER == parameterType.getValueType()) {
            return ModelUtil.parseInteger(value);
        }
        if (ValueType.LONG == parameterType.getValueType()) {
            return ModelUtil.parseLong(value, 16);
        }
        return value;
    }
}

