/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.handler;

import com.freescale.s32ds.cross.core.model.DefaultParameterHandler;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.context.ContextChange;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureSlaveData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CoProcessorHandler
extends DefaultParameterHandler {
    private final Map<String, Boolean> processorGraphEnableMap = new HashMap<String, Boolean>();

    public ChangeResult onInit(String tag, Object newValue, AbstractContext context) {
        CoreNatureSlaveData coProcessor = this.getCoProcessor(tag, context);
        if (coProcessor == null) {
            return null;
        }
        String prefix = tag.contains("GraphEnable") ? tag.replace("GraphEnable", "") : tag.replace("Enable", "");
        ContextChange change = new ContextChange(context, String.valueOf(prefix) + "Enable");
        change.addValue(String.valueOf(prefix) + "Enable", (Object)coProcessor.isEnabledByDefault());
        change.addValue(String.valueOf(prefix) + "GraphEnable", (Object)coProcessor.isEnabledByDefault());
        return new ChangeResult(Arrays.asList(change));
    }

    public ChangeResult onEdit(String tag, Object newValue, AbstractContext context) {
        CoreNatureSlaveData coProcessor = this.getCoProcessor(tag, context);
        if (coProcessor == null) {
            return null;
        }
        String prefix = tag.contains("GraphEnable") ? tag.replace("GraphEnable", "") : tag.replace("Enable", "");
        ContextChange change = new ContextChange(context, String.valueOf(prefix) + "Enable");
        boolean coProcessorEnabled = (Boolean)newValue;
        boolean graphEnabled = this.isGraphEnabled(coProcessorEnabled, coProcessor, context);
        change.addValue(String.valueOf(prefix) + "GraphEnable", (Object)graphEnabled);
        if (!coProcessorEnabled) {
            String coProcessor_tag = null;
            if ("apuCoProcessor".equalsIgnoreCase(prefix)) {
                coProcessor_tag = "ispCoProcessor";
            } else if ("ispCoProcessor".equalsIgnoreCase(prefix)) {
                coProcessor_tag = "apuCoProcessor";
            }
            if (coProcessor_tag != null) {
                change.addValue(String.valueOf(coProcessor_tag) + "Enable", (Object)(!coProcessorEnabled ? 1 : 0));
                change.addValue(String.valueOf(coProcessor_tag) + "GraphEnable", (Object)(!coProcessorEnabled ? 1 : 0));
            }
        }
        return new ChangeResult(Arrays.asList(change));
    }

    private CoreNatureSlaveData getCoProcessor(String tag, AbstractContext context) {
        Parameter parameter = context.getParameter(tag);
        ParameterType refParameterType = parameter.getType().getRefParameterType();
        if (refParameterType != null && refParameterType.getTag().equals("coProcessor") && context instanceof CProjectMasterContext) {
            CoreNatureData coreNature = ((CProjectMasterContext)context).getCoreNature();
            if (tag.contains("CoProcessor")) {
                String[] split = tag.split("CoProcessor");
                CoreNatureSlaveData coProcessor = coreNature.getSlave(split[0]);
                return coProcessor;
            }
        }
        return null;
    }

    private boolean isGraphEnabled(boolean coProcessorEnabled, CoreNatureSlaveData coProcessor, AbstractContext context) {
        boolean graphEnabled = coProcessorEnabled;
        Parameter graphEnabledParameter = context.getParameter("coProcessorGraphEnable");
        Parameter coProcessorEnabledParameter = context.getParameter("coProcessorEnable");
        if (coProcessorEnabledParameter != null && coProcessorEnabledParameter.isVisible() && graphEnabledParameter != null && graphEnabledParameter.isVisible()) {
            if (coProcessorEnabled) {
                Boolean b = this.processorGraphEnableMap.get(coProcessor.getParent().getId());
                graphEnabled = b != null ? b : graphEnabled;
            } else {
                this.processorGraphEnableMap.put(coProcessor.getParent().getId(), context.getBooleanValue("coProcessorGraphEnable"));
            }
        }
        return graphEnabled;
    }
}

