/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.template;

import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.TemplateEngine2;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class SetPathMapping
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        if (args == null || args.length < 2) {
            S32DSWizardPlugin.logWarning("Data for SetPathMapping should contain more input parameters !");
            return;
        }
        String envVarName = null;
        String varName = null;
        String projectName = null;
        String fullPath = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument pa = processArgumentArray[n2];
            pa.resolve();
            String name = pa.getName();
            if (pa.getParameterType() == 1) {
                if ("name".equals(name)) {
                    envVarName = pa.getSimpleValue();
                } else if ("variable".equals(name)) {
                    varName = pa.getSimpleValue();
                } else if ("projectName".equals(name)) {
                    projectName = pa.getSimpleValue();
                }
            }
            ++n2;
        }
        ICProjectDescriptionManager projectDescriptionManager = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription prjDescription = projectDescriptionManager.getProjectDescription(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
        if (prjDescription == null) {
            return;
        }
        ICConfigurationDescription cfgDescription = prjDescription.getDefaultSettingConfiguration();
        ICdtVariableManager varManager = CCorePlugin.getDefault().getCdtVariableManager();
        try {
            fullPath = varManager.resolveValue(envVarName, "", null, cfgDescription);
        }
        catch (CdtVariableException e) {
            S32DSWizardPlugin.log(e);
        }
        if (fullPath == null) {
            S32DSWizardPlugin.logWarning("SetPathMapping: full path is incorrect");
            return;
        }
        Map macros = template.getValueStore();
        Map map = TemplateEngine.getSharedDefaults();
        macros.put(varName, fullPath);
        map.put(varName, fullPath);
        TemplateEngine2.getDefault().updateSharedDefaults(template);
    }
}

