/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.operations;

import com.nxp.s32ds.ext.ide.core.refactoring.IRenameParticipant;
import com.nxp.s32ds.ext.ide.examples.core.ProjectSet;
import com.nxp.s32ds.ext.ide.examples.ui.internal.ExIdtUiExamplesActivator;
import com.nxp.s32ds.ext.ide.ui.utils.RenameOperationContext;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractOperation
extends WorkspaceModifyOperation {
    private final ProjectSet projects;
    private final RenameOperationContext util;

    public AbstractOperation(String name, ProjectSet projects, List<IRenameParticipant> importRefactoringPaticipants) {
        this.projects = projects;
        this.util = new RenameOperationContext(name, projects, importRefactoringPaticipants);
    }

    public void execute(IProgressMonitor monitor) {
        try {
            ArrayList<IProject> projectsPerfomed = new ArrayList<IProject>();
            for (IProjectDescription iter : this.projects.getProjects().collect(Collectors.toList())) {
                try {
                    IProject newProject = this.util.performProjectOperation(iter, monitor);
                    newProject.refreshLocal(2, monitor);
                    projectsPerfomed.add(newProject);
                }
                catch (InterruptedException | InvocationTargetException | CoreException | BackingStoreException e) {
                    ExIdtUiExamplesActivator.log(e);
                }
            }
            for (IProject itr : projectsPerfomed) {
                this.postExecuteStep(itr);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void postExecuteStep(IProject project) {
    }
}

