/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms.chip.edit;

import com.pemicro.forms.chip.ChipResponse;
import com.pemicro.forms.chip.Signal;
import com.pemicro.forms.chip.data.PinData;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;

public class DataTypeEditingSupport
extends EditingSupport {
    private final TableViewer viewer;

    public DataTypeEditingSupport(TableViewer viewer) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
    }

    protected CellEditor getCellEditor(Object element) {
        String[] dataType = new String[]{"Digital", "Analog"};
        return new ComboBoxCellEditor((Composite)this.viewer.getTable(), dataType, 8);
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        return ((Signal)element).getDataType();
    }

    protected void setValue(Object element, Object value) {
        PinData data = ((Signal)element).getPinData();
        if (((Integer)value).intValue() != data.getDataType()) {
            ChipResponse.setControlChanged(true);
            ChipResponse.setPinID(data.getID());
            ChipResponse.setModuleName(data.getModuleName());
            ChipResponse.setDataType((Integer)value);
        }
    }
}

