/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms.chip.widget;

import com.pemicro.forms.chip.Signal;
import com.pemicro.forms.chip.SignalView;
import com.pemicro.forms.chip.SignalWindow;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalListDialog
extends Dialog {
    List<Signal> signals;
    org.eclipse.swt.widgets.List available;
    org.eclipse.swt.widgets.List displayed;
    String[] availableSignals;
    String[] displayedSignals;
    String transfered;

    public SignalListDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(0x1000000, 0x1000000, true, true);
        data.widthHint = 200;
        data.heightHint = 300;
        this.available = new org.eclipse.swt.widgets.List(composite, 2560);
        this.available.setLayoutData((Object)data);
        Composite arrowComposite = new Composite(composite, 0);
        GridLayout arrowLayout = new GridLayout(1, false);
        arrowComposite.setLayout((Layout)arrowLayout);
        data = new GridData(0x1000000, 0x1000000, true, true);
        data.widthHint = 25;
        Button leftArrow = new Button(arrowComposite, 16388);
        leftArrow.setLayoutData((Object)data);
        data = new GridData(0x1000000, 0x1000000, true, true);
        data.widthHint = 25;
        Button rightArrow = new Button(arrowComposite, 131076);
        rightArrow.setLayoutData((Object)data);
        data = new GridData(0x1000000, 0x1000000, true, true);
        data.widthHint = 200;
        data.heightHint = 300;
        this.displayed = new org.eclipse.swt.widgets.List(composite, 2560);
        this.displayed.setLayoutData((Object)data);
        composite.pack();
        this.available.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SignalListDialog.this.displayed.deselectAll();
            }
        });
        this.displayed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SignalListDialog.this.available.deselectAll();
            }
        });
        rightArrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (SignalListDialog.this.available.getSelectionIndex() != -1) {
                    int selection = SignalListDialog.this.available.getSelectionIndex();
                    SignalListDialog.this.transfered = SignalListDialog.this.available.getSelection()[0];
                    SignalListDialog.this.available.remove(SignalListDialog.this.available.getSelectionIndex());
                    if (selection < SignalListDialog.this.available.getItemCount()) {
                        SignalListDialog.this.available.select(selection);
                    } else {
                        SignalListDialog.this.available.select(selection - 1);
                    }
                    SignalListDialog.this.displayed.add(SignalListDialog.this.transfered);
                }
            }
        });
        leftArrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (SignalListDialog.this.displayed.getSelectionIndex() != -1) {
                    int selection = SignalListDialog.this.displayed.getSelectionIndex();
                    SignalListDialog.this.transfered = SignalListDialog.this.displayed.getSelection()[0];
                    SignalListDialog.this.displayed.remove(SignalListDialog.this.displayed.getSelectionIndex());
                    if (selection < SignalListDialog.this.displayed.getItemCount()) {
                        SignalListDialog.this.displayed.select(selection);
                    } else {
                        SignalListDialog.this.displayed.select(selection - 1);
                    }
                    SignalListDialog.this.available.add(SignalListDialog.this.transfered);
                }
            }
        });
        if (this.availableSignals != null) {
            this.available.setItems(this.availableSignals);
        }
        if (this.displayedSignals != null) {
            this.displayed.setItems(this.displayedSignals);
        }
        return composite;
    }

    protected void initializeBounds() {
        super.getButtonBar().setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        super.initializeBounds();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Signal List");
    }

    public void setSignals(List<Signal> signals) {
        int j;
        this.signals = signals;
        int availableCount = 0;
        int displayedCount = 0;
        int i = 0;
        while (i < signals.size()) {
            if (signals.get(i).getPinData().isDisplayed()) {
                ++displayedCount;
            } else {
                ++availableCount;
            }
            ++i;
        }
        this.availableSignals = new String[availableCount];
        this.displayedSignals = new String[displayedCount];
        i = 0;
        while (i < availableCount) {
            j = 0;
            while (j < signals.size()) {
                if (!signals.get(j).getPinData().isDisplayed()) {
                    this.availableSignals[i] = String.valueOf(signals.get(j).getSignalName().length() == 0 ? "---" : signals.get(j).getSignalName()) + " (" + signals.get(j).getPinName() + ")";
                    ++i;
                }
                ++j;
            }
        }
        i = 0;
        while (i < displayedCount) {
            j = 0;
            while (j < signals.size()) {
                if (signals.get(j).getPinData().isDisplayed()) {
                    this.displayedSignals[i] = String.valueOf(signals.get(j).getSignalName().length() == 0 ? "---" : signals.get(j).getSignalName()) + " (" + signals.get(j).getPinName() + ")";
                    ++i;
                }
                ++j;
            }
        }
    }

    public boolean close() {
        String pinName;
        String signalName;
        StringTokenizer st;
        this.availableSignals = this.available.getItems();
        this.displayedSignals = this.displayed.getItems();
        int i = 0;
        while (i < this.availableSignals.length) {
            st = new StringTokenizer(this.availableSignals[i], " (");
            signalName = st.nextToken().replace("---", "");
            pinName = st.nextToken().replace(")", "");
            SignalWindow.getInstance().getSignal(pinName, signalName).setDisplayed(false);
            SignalWindow.getInstance().getDisplayedSignalMap().remove(SignalWindow.getInstance().getSignal(pinName, signalName).getID());
            ++i;
        }
        i = 0;
        while (i < this.displayedSignals.length) {
            st = new StringTokenizer(this.displayedSignals[i], " (");
            signalName = st.nextToken().replace("---", "");
            pinName = st.nextToken().replace(")", "");
            SignalWindow.getInstance().getSignal(pinName, signalName).setDisplayed(true);
            SignalWindow.getInstance().getDisplayedSignalMap().put(SignalWindow.getInstance().getSignal(pinName, signalName).getID(), SignalWindow.getInstance().getSignal(pinName, signalName));
            ++i;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        SignalView view = (SignalView)page.findView("com.pemicro.core.signalView");
        view.getViewer().refresh();
        return super.close();
    }
}

