/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.ui.buildconfig;

import com.freescale.s32ds.cdt.ui.buildconfig.Activator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.services.IServiceLocator;

public class BuildPathUtils {
    private BuildPathUtils() {
    }

    public static IProject getProject(List<IResource> res) {
        switch (res.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return res.get(0).getProject();
            }
        }
        IProject tail = BuildPathUtils.getProject(res.subList(res.size() / 2, res.size()));
        return tail != null && tail.equals((Object)BuildPathUtils.getProject(res.subList(0, res.size() / 2))) ? tail : null;
    }

    public static Collection<ICConfigurationDescription> getBuildConfigurations(List<IResource> resources) {
        ICProjectDescription desc = CoreModel.getDefault().getProjectDescription(BuildPathUtils.getProject(resources), true);
        return desc == null ? null : new ArrayList<ICConfigurationDescription>(desc){
            {
                ICConfigurationDescription[] iCConfigurationDescriptionArray = iCProjectDescription.getConfigurations();
                int n = iCConfigurationDescriptionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICConfigurationDescription configuration = iCConfigurationDescriptionArray[n2];
                    this.add(configuration);
                    ++n2;
                }
            }
        };
    }

    public static ISelection getSelection(IServiceLocator serviceLocator) {
        return ((ISelectionService)serviceLocator.getService(ISelectionService.class)).getSelection();
    }

    private static IResource getResource(Object obj) {
        IAdaptable adaptable;
        IResource resource;
        if (obj instanceof IResource) {
            return (IResource)obj;
        }
        if (obj instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)obj).getAdapter(IResource.class)) != null) {
            return resource;
        }
        return null;
    }

    public static List<IResource> getSelectedResources(ISelection selection) {
        return new ArrayList<IResource>(selection){
            {
                if (iSelection instanceof TreeSelection) {
                    TreeSelection treeSelection = (TreeSelection)iSelection;
                    Object[] objectArray = treeSelection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        IResource resource = BuildPathUtils.getResource(obj);
                        if (resource != null) {
                            this.add(resource);
                        }
                        ++n2;
                    }
                }
            }
        };
    }

    public static boolean isOnSourcePath(IResource resource, ICSourceEntry[] roots) {
        ICSourceEntry[] iCSourceEntryArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            ICSourceEntry root = iCSourceEntryArray[n2];
            if (CDataUtil.isOnSourceEntry((IPath)resource.getFullPath(), (ICSourceEntry)root)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void setExcluded(List<IResource> resources, ICConfigurationDescription desc, boolean excluded) throws WriteAccessException, CoreException {
        IProject project = BuildPathUtils.getProject(resources);
        for (IResource resource : resources) {
            try {
                desc.setSourceEntries(CDataUtil.setExcluded((IPath)resource.getFullPath(), (boolean)(resource instanceof IFolder), (boolean)excluded, (ICSourceEntry[])desc.getSourceEntries()));
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
        CoreModel.getDefault().setProjectDescription(project, desc.getProjectDescription());
    }

    public static boolean canExclude(IResource resource, boolean excluded, ICSourceEntry[] entries) {
        ICSourceEntry[] out;
        block3: {
            try {
                out = CDataUtil.setExcluded((IPath)resource.getFullPath(), (boolean)(resource instanceof IFolder), (boolean)excluded, (ICSourceEntry[])entries, (boolean)false);
                if (entries == null || out != null) break block3;
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return !CDataUtil.isEqual((ICSourceEntry[])entries, (ICSourceEntry[])out);
    }
}

