/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard;

import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.wizard.ContextQualifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.Control;

public class ParameterControl {
    private final String contextKey;
    private final int columnIndex;
    private final int rowIndex;
    private final Control control;
    private final ParameterType parameterType;
    private final CProjectContext projectContext;
    private final ProcessorContext processorContext;
    private final boolean containsData;

    public ParameterControl(String contextKey, ProcessorContext processorContext, ParameterType parameterType, Control control, int rowIndex, int columnIndex, boolean containsData) {
        this.contextKey = contextKey;
        this.processorContext = processorContext;
        this.projectContext = processorContext.getProjectContext(contextKey);
        this.parameterType = parameterType;
        this.columnIndex = columnIndex;
        this.rowIndex = rowIndex;
        this.control = control;
        this.containsData = containsData;
    }

    public ProcessorContext getProcessorContext() {
        return this.processorContext;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Control getControl() {
        return this.control;
    }

    public String getTag() {
        return this.parameterType.getTag();
    }

    public ParameterType getParameterType() {
        return this.parameterType;
    }

    public CProjectContext getProjectContext() {
        return this.projectContext;
    }

    public String getContextKey() {
        return this.contextKey;
    }

    public boolean containsData() {
        return this.containsData;
    }

    public boolean isSingle() {
        return this.projectContext != null ? this.projectContext.isParameterSingle(this.parameterType.getTag()) : false;
    }

    public void updateState() {
        if (this.parameterType == null || this.parameterType.getTag().equals("core")) {
            return;
        }
        if (this.control != null && !this.control.isDisposed() && this.projectContext != null) {
            this.control.setEnabled(this.projectContext.isActive());
        }
    }

    public String toString() {
        return this.parameterType.toString();
    }

    public static List<ParameterControl> filterControls(ContextQualifier contextQualifier, Collection<ParameterControl> controls) {
        ArrayList<ParameterControl> result = new ArrayList<ParameterControl>();
        for (ParameterControl c : controls) {
            Collection<String> ps;
            if (!contextQualifier.getContextKeys().contains(c.getContextKey()) || !(ps = contextQualifier.getParameters(c.getContextKey())).isEmpty() && !ps.contains(c.getTag())) continue;
            result.add(c);
        }
        return result;
    }

    public static List<ParameterControl> filterControls(Collection<String> tags, Collection<ParameterControl> controls) {
        ArrayList<ParameterControl> result = new ArrayList<ParameterControl>();
        for (ParameterControl c : controls) {
            if (!tags.contains(c.getTag())) continue;
            result.add(c);
        }
        return result;
    }

    public static List<ParameterControl> filterControls(Collection<ParameterControl> controls, String ... tags) {
        return ParameterControl.filterControls(Arrays.asList(tags), controls);
    }

    public static List<ParameterControl> filterControls(CProjectContext projectContext, List<ParameterControl> controls) {
        ContextQualifier contextQualifier = new ContextQualifier();
        contextQualifier.add(projectContext.getCoreNatureId(), new String[0]);
        return ParameterControl.filterControls(contextQualifier, controls);
    }
}

