/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.imports;

import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.imports.AbstractImportPage;
import com.freescale.s32ds.cross.wizard.imports.IImportConverter;
import com.freescale.s32ds.cross.wizard.imports.ImportConvertorHolder;
import com.freescale.s32ds.cross.wizard.imports.SearchDialog;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.Bundle;

public class ImportPage
extends AbstractImportPage {
    private static final String TITLE_WIZ = Messages.ImportPage_ConvertAutomotiveProject;
    private static final String DESCR_WIZ = Messages.ImportPage_CreateNewProject;
    public static final String EMP = "";
    private static final String CPROJECT = ".cproject";
    private static final String NO = "NO";
    private IToolChain sel_tool = null;
    private final Collection<ImportConvertorHolder> convs;
    private Table table;
    private Button use_pe;
    private Button copy;
    private Text descr;
    protected final ImageDescriptor IMG = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"com.freescale.s32ds.cross.wizard"), (IPath)new Path("s32ds32.png"), null));

    public ImportPage(Collection<ImportConvertorHolder> cs) {
        super(TITLE_WIZ, DESCR_WIZ);
        this.setImageDescriptor(this.IMG);
        this.convs = cs;
    }

    public String getLocation() {
        return this.location.getText().trim();
    }

    public IToolChain getToolchain() {
        return this.sel_tool;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addSourceSelector(comp);
        this.addProjectNameSelector(comp);
        this.validatePage();
        this.addToolSelector(comp);
        this.addTable(comp);
        this.addSearch(comp);
        this.setControl((Control)comp);
    }

    private void addTable(Composite comp) {
        Iterator<ImportConvertorHolder> iterator;
        Composite ct = new Composite(comp, 0);
        ct.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, true);
        ct.setLayout((Layout)layout);
        Label lb = new Label(ct, 0);
        lb.setText(this.convs.size() == 1 ? Messages.ImportPage_ActiveConverter : Messages.ImportPage_SelectProjectTypes);
        lb.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.table = new Table(ct, 2592);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setLinesVisible(true);
        this.table.setToolTipText(Messages.ImportPage_ListOfImporters);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o;
                if (e.detail == 32 && ImportPage.this.convs.size() == 1) {
                    ImportPage.this.table.getItems()[0].setChecked(true);
                }
                String txt = ImportPage.EMP;
                if (e.item != null && (o = e.item.getData()) instanceof ImportConvertorHolder) {
                    txt = ((ImportConvertorHolder)o).descr;
                }
                ImportPage.this.descr.setText(txt);
                ImportPage.this.validatePage();
            }
        });
        this.descr = new Text(ct, 2634);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumHeight = 60;
        gd.heightHint = 60;
        gd.minimumWidth = 200;
        gd.widthHint = 200;
        this.descr.setLayoutData((Object)gd);
        this.descr.setToolTipText(Messages.ImportPage_SelectedImporterDescription);
        if (this.convs.size() > 0 && (iterator = this.convs.iterator()).hasNext()) {
            ImportConvertorHolder c = iterator.next();
            this.descr.setText(c.descr);
        }
        for (ImportConvertorHolder c : this.convs) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(c.label);
            item.setImage(c.image);
            item.setChecked(true);
            item.setData((Object)c);
        }
    }

    @Override
    public void callSearch(String path) {
        SearchDialog.start(this.location, path, this.getActiveConvs(), this.isStrict(), this.isPE());
    }

    private void addSourceSelector(Composite parent) {
        this.location = this.setText(parent, Messages.ImportPage_ExistingProjectLocation);
        Button browse = new Button(this.location.getParent(), 0);
        browse.setLayoutData((Object)new GridData(4, 4, false, true));
        browse.setText(Messages.ImportPage_Browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ImportPage.this.location.getShell());
                dialog.setMessage(Messages.ImportPage_SelectExistingProject);
                String dir = dialog.open();
                if (dir != null) {
                    String name = new File(dir).getName();
                    ImportPage.this.location.setText(name);
                    if (!ImportPage.this.projectName.isDisposed()) {
                        ImportPage.this.projectName.setText(name);
                    }
                    ImportPage.this.location.setText(dir);
                }
            }
        });
        this.use_pe = this.setButton(this.location.getParent(), Messages.ImportPage_AllowImportWithPE, true);
        this.copy = this.setButton(this.location.getParent(), Messages.ImportPage_CopyIntoWorkspace, true);
    }

    private Button setButton(Composite c, String s, boolean state) {
        Button b = new Button(c, 32);
        b.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        b.setText(s);
        b.setSelection(state);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportPage.this.validatePage();
            }
        });
        return b;
    }

    private void addToolSelector(Composite parent) {
        IToolChain[] toolChains;
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.ImportPage_ToolchainToBeApplied);
        ArrayList<IToolChain> tm = new ArrayList<IToolChain>();
        IToolChain[] iToolChainArray = toolChains = ManagedBuildManager.getRealToolChains();
        int n = toolChains.length;
        int n2 = 0;
        while (n2 < n) {
            IToolChain toolChain = iToolChainArray[n2];
            if (!toolChain.isAbstract() && !toolChain.isSystemObject()) {
                for (ImportConvertorHolder c : this.convs) {
                    if (!c.isToolchainSupported(toolChain.getId())) continue;
                    tm.add(toolChain);
                    break;
                }
            }
            ++n2;
        }
        if (!tm.isEmpty()) {
            for (IToolChain s : tm) {
                Button b = new Button((Composite)group, 16);
                if (this.sel_tool == null) {
                    b.setSelection(true);
                    this.sel_tool = s;
                } else {
                    b.setSelection(false);
                }
                b.setText(s.getName());
                b.setData((Object)s);
                b.setLayoutData((Object)new GridData(4, 4, true, true));
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ImportPage.this.sel_tool = (IToolChain)e.data;
                        ImportPage.this.validatePage();
                    }
                });
            }
        } else {
            Label l = new Label((Composite)group, 2048);
            l.setLayoutData((Object)new GridData(4, 4, true, true));
            l.setText(EMP);
        }
    }

    @Override
    protected void validatePage() {
        super.validatePage();
        boolean complete = true;
        String name = this.getProjectName();
        if (this.msg == null && name.isEmpty()) {
            complete = false;
        }
        if (this.msg == null) {
            String loc = this.getLocation();
            if (loc.isEmpty()) {
                complete = false;
            } else {
                final File file = new File(loc);
                if (file.isDirectory()) {
                    if (!file.canWrite()) {
                        this.msg = Messages.ImportPage_DirectoryReadOnly;
                    } else if (!this.projectNameSetByUser && !name.equals(file.getName())) {
                        WorkbenchJob wjob = new WorkbenchJob(Messages.ImportPage_UpdateProjectName){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (!ImportPage.this.projectName.isDisposed()) {
                                    ImportPage.this.projectName.setText(file.getName());
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        wjob.setSystem(true);
                        wjob.schedule();
                    }
                } else {
                    this.msg = Messages.ImportPage_DirectoryNotValid;
                }
            }
        }
        if (this.msg == null) {
            String fn = String.valueOf(this.getLocation()) + File.separator + CPROJECT;
            File proj = new File(fn);
            if (proj.exists()) {
                boolean fits = false;
                for (ImportConvertorHolder c : this.getActiveConvs()) {
                    if (((IImportConverter)c.clazz).fits(this.getLocation(), this.isStrict(), this.isPE()) != null) continue;
                    this.projectImage = c.image;
                    this.projectType.setToolTipText(String.valueOf(Messages.ImportPage_ThisProjectAllows) + c.label);
                    fits = true;
                    break;
                }
                if (!fits) {
                    this.msg = Messages.ImportPage_ProjectNotSupported;
                }
            } else if (complete) {
                this.msg = Messages.ImportPage_NoCprojects;
            }
        }
        this.projectType.redraw();
        this.setErrorMessage(this.msg);
        this.setPageComplete(this.msg == null && complete);
        this.copy.setEnabled(!this.getLocation().replace('\\', '/').startsWith(WORKSPACE));
    }

    public List<ImportConvertorHolder> getActiveConvs() {
        ArrayList<ImportConvertorHolder> arr = new ArrayList<ImportConvertorHolder>();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            if (ti.getChecked()) {
                arr.add((ImportConvertorHolder)ti.getData());
            }
            ++n2;
        }
        return arr;
    }

    public boolean isDefaultLocation(IPath path) {
        if (path.segmentCount() < 2) {
            return false;
        }
        return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
    }

    public void handleEvent(Event event) {
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    public boolean isStrict() {
        return true;
    }

    public boolean isPE() {
        return this.use_pe == null ? true : this.use_pe.getSelection();
    }

    public boolean needCopy() {
        return this.copy.getEnabled() && this.copy.getSelection();
    }

    public String queryOverwrite(String pathString) {
        if (pathString.endsWith(CPROJECT)) {
            return NO;
        }
        if (pathString.endsWith(".settings")) {
            return NO;
        }
        if (pathString.endsWith("language.settings.xml")) {
            return NO;
        }
        return super.queryOverwrite(pathString);
    }
}

