/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page1;

import com.freescale.s32ds.cross.core.model.CdtTemplateInfo;
import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorConfiguration;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import com.freescale.s32ds.cross.wizard.DescriptionUpdater;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.page1.Page1Manager;
import com.freescale.s32ds.cross.wizard.page1.Page1Utils;
import com.freescale.s32ds.cross.wizard.page1.ToolChainSelectionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class ContentComposite
extends Composite {
    private final Tree hardwareTree;
    private final Table configurationTable;
    private final Text descriptionText;
    private final Page1Manager pageManager;
    private final boolean executable;
    private final List<Control> combos = new ArrayList<Control>();
    private final List<TableEditor> editors = new ArrayList<TableEditor>();

    public ContentComposite(Page1Manager pageManager, boolean executable, Composite parent, int style) {
        super(parent, style);
        this.pageManager = pageManager;
        this.executable = executable;
        this.setLayoutData(new GridData(1808));
        this.setLayout((Layout)new GridLayout(2, false));
        SashForm form = new SashForm((Composite)this, 256);
        form.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite treeComposite = new Composite((Composite)form, 4);
        treeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        treeComposite.setLayout((Layout)new GridLayout());
        pageManager.getWizardPage().setLabel(treeComposite, "Processors :");
        this.hardwareTree = this.createHardwareTree(treeComposite, 67588);
        TreeItem[] treeItemArray = this.hardwareTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            item.setExpanded(false);
            ++n2;
        }
        Composite configurationComposite = new Composite((Composite)form, 4);
        configurationComposite.setLayoutData((Object)new GridData(1808));
        configurationComposite.setLayout((Layout)new GridLayout());
        pageManager.getWizardPage().setLabel(configurationComposite, "ToolChain Selection: ");
        this.configurationTable = Page1Utils.createTable(configurationComposite);
        pageManager.getWizardPage().setLabel(configurationComposite, "Description :");
        this.descriptionText = Page1Utils.createHelpText(configurationComposite, this.getDescriptionText());
        form.setWeights(new int[]{2, 3});
        this.initContent();
    }

    public Page1Manager getPageManager() {
        return this.pageManager;
    }

    public Tree getHardwareTree() {
        return this.hardwareTree;
    }

    public abstract void select(ConfigurationData var1);

    protected abstract Tree createHardwareTree(Composite var1, int var2);

    protected abstract void initContent();

    protected void updateProcessorConfiguration(ProcessorData processor) {
        ProcessorData currentProcessor;
        Object data;
        if (processor == null) {
            return;
        }
        if (this.configurationTable.getItems().length > 0 && (data = this.configurationTable.getData()) instanceof ProcessorData && (currentProcessor = (ProcessorData)data).equals(processor)) {
            return;
        }
        this.clearConfigurationTable();
        this.configurationTable.setData((Object)processor);
        List cConfigurations = CoreNatureConfiguration.getDefaults((ProcessorData)processor, (boolean)this.executable);
        for (CoreNatureData coreNature : processor.getCoreNatures(this.executable)) {
            TableItem ti = new TableItem(this.configurationTable, 0);
            ti.setText(0, coreNature.getCoreKindId());
            ti.setText(1, coreNature.getName());
            this.createToolChainsEditor(ti, coreNature);
        }
        if (cConfigurations.size() > 0) {
            this.getContext().setCurrentProcessorConfiguration(new ProcessorConfiguration(processor, (Collection)cConfigurations, this.executable));
        }
        DescriptionUpdater.updateDescription(this.descriptionText, this.getContext().getCurrentProcessorConfiguration());
        this.checkPageComplete();
    }

    protected void updateFamilyData(FamilyData data) {
        this.clearConfigurationTable();
        if (data == null) {
            return;
        }
        DescriptionUpdater.updateDescription(this.descriptionText, data);
        this.checkPageComplete();
    }

    protected void clearConfigurationTable() {
        this.configurationTable.removeAll();
        for (Control combo : this.combos) {
            if (combo.isDisposed()) continue;
            combo.dispose();
        }
        this.combos.clear();
        for (TableEditor editor : this.editors) {
            editor.dispose();
        }
        this.editors.clear();
    }

    protected void createToolChainsEditor(TableItem tableItem, CoreNatureData coreNature) {
        List cConfigurations = CoreNatureConfiguration.getAll((CoreNatureData)coreNature);
        if (cConfigurations.isEmpty()) {
            tableItem.setText(2, "Templates not found!");
            return;
        }
        CCombo combo = new CCombo((Composite)this.configurationTable, 12);
        this.combos.add((Control)combo);
        TableEditor editor = new TableEditor(this.configurationTable);
        this.editors.add(editor);
        editor.grabHorizontal = true;
        editor.setEditor((Control)combo, tableItem, 2);
        for (CoreNatureConfiguration cConfiguration : cConfigurations) {
            CdtTemplateInfo toolChainInfo = cConfiguration.getTemplate().getTemplateInfo(this.isExecutable());
            if (toolChainInfo == null) continue;
            String toolChainId = toolChainInfo.getToolChainId();
            IToolChain toolChain = this.getRegistry().getToolChain(toolChainId);
            if (toolChain != null) {
                String name = toolChain.getName();
                if (name == null || name.isEmpty()) {
                    name = toolChain.getId();
                }
                combo.add(name);
                combo.setData(name, (Object)toolChain);
                continue;
            }
            S32DSWizardPlugin.logWarning("No toolchain found for toolchainId: " + toolChainId);
        }
        if (combo instanceof CCombo && combo.getItems().length > 0) {
            combo.select(0);
        }
        combo.computeSize(-1, -1);
        combo.addSelectionListener((SelectionListener)new ToolChainSelectionAdapter(combo, coreNature, this.getContext(), this.descriptionText));
    }

    protected ModelRegistry getRegistry() {
        return this.pageManager.getContext().getRegistry();
    }

    protected GeneralContext getContext() {
        return this.pageManager.getContext();
    }

    protected void checkPageComplete() {
        this.pageManager.getWizardPage().setPageComplete(this.pageManager.getWizardPage().validatePage());
    }

    protected String getDescriptionText() {
        return "Help text";
    }

    protected void selectTreeItem(TreeItem treeItem) {
        this.getHardwareTree().select(treeItem);
        Event event = ContentComposite.createSelectionEvent(treeItem);
        this.getHardwareTree().notifyListeners(13, event);
    }

    protected void updateContent(Object data) {
        if (data == null) {
            this.getPageManager().getWizardPage().setPageComplete(false);
            this.pageManager.setSelectedProcessor(null);
            this.clearConfigurationTable();
            DescriptionUpdater.setDefaultDescription(this.descriptionText);
        } else if (data instanceof ProcessorData) {
            this.pageManager.setSelectedProcessor((ProcessorData)data);
            this.updateProcessorConfiguration((ProcessorData)data);
            this.getPageManager().getWizardPage().setPageComplete(this.getPageManager().getWizardPage().validatePage());
        } else if (data instanceof FamilyData) {
            this.pageManager.setSelectedProcessor(null);
            this.updateFamilyData((FamilyData)data);
            this.getPageManager().getWizardPage().setPageComplete(false);
        }
    }

    public static String displayTitle(String nameToDisplay) {
        return String.valueOf(nameToDisplay.substring(0, 1).toUpperCase()) + nameToDisplay.substring(1);
    }

    public static Event createSelectionEvent(TreeItem treeItem) {
        Event event = new Event(){};
        event.item = treeItem;
        event.doit = true;
        return event;
    }

    public boolean isExecutable() {
        return this.executable;
    }
}

