/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.makefilegenerator;

import com.nxp.s32ds.ext.cdt.core.makefilegenerator.BaseManagedCommandLineInfo;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.CoreIDEMakefileGenerator;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.FSLPathUtil;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.LinkOrder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;

public class BaseCommandLineGenerator
implements IManagedCommandLineGenerator {
    public static final String DEFAULT_PATTERN = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG}${OUTPUT_PREFIX}${OUTPUT} -XLnk \"${INPUTS}\"";
    public final String VAR_FIRST_CHAR = "$";
    public final char VAR_SECOND_CHAR = (char)123;
    public final String VAR_FINAL_CHAR = "}";
    public final String CLASS_PROPERTY_PREFIX = "get";
    public final String CMD_LINE_PRM_NAME = "COMMAND";
    public final String FLAGS_PRM_NAME = "FLAGS";
    public final String OUTPUT_FLAG_PRM_NAME = "OUTPUT_FLAG";
    public final String OUTPUT_PREFIX_PRM_NAME = "OUTPUT_PREFIX";
    public final String OUTPUT_PRM_NAME = "OUTPUT";
    public final String INPUTS_PRM_NAME = "INPUTS";
    private CoreIDEMakefileGenerator coreIDEMakefileGenerator;

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        CoreIDEMakefileGenerator makefileGenerator;
        LinkOrder linkOrder = new LinkOrder(tool);
        if (tool != null && linkOrder.isEnabled() && (makefileGenerator = this.getMakefileGenerator()) != null) {
            IConfiguration configuration = makefileGenerator.getConfig();
            linkOrder.update(configuration);
        }
        StringBuffer sb = new StringBuffer();
        if (commandLinePattern == null || commandLinePattern.length() <= 0) {
            commandLinePattern = DEFAULT_PATTERN;
        }
        int start = 0;
        int stop = 0;
        while ((start = commandLinePattern.indexOf("$", start)) >= 0) {
            if (commandLinePattern.charAt(start + 1) != '{') {
                sb.append(commandLinePattern.substring(stop, ++start));
                stop = start;
                continue;
            }
            if (start > stop) {
                sb.append(commandLinePattern.substring(stop, start));
            }
            if ((stop = commandLinePattern.indexOf("}", start + 1)) > 0 && stop <= commandLinePattern.length()) {
                try {
                    StringBuffer tempBuffer;
                    String varName = commandLinePattern.substring(start + 2, stop).trim();
                    if (varName.compareToIgnoreCase("COMMAND") == 0) {
                        sb.append(commandName.trim());
                    } else if (varName.compareToIgnoreCase("FLAGS") == 0) {
                        sb.append(this.stringArrayToString(flags));
                    } else if (varName.compareToIgnoreCase("OUTPUT_FLAG") == 0) {
                        sb.append(outputFlag.trim());
                    } else if (varName.compareToIgnoreCase("OUTPUT_PREFIX") == 0) {
                        sb.append(outputPrefix.trim());
                    } else if (varName.compareToIgnoreCase("OUTPUT") == 0) {
                        tempBuffer = new StringBuffer("");
                        if (!outputName.equals("")) {
                            if (outputName.length() > 0 && !FSLPathUtil.isQuoted(outputName)) {
                                tempBuffer.append("\"" + outputName + "\"");
                            } else {
                                tempBuffer.append(outputName);
                            }
                        }
                        sb.append(tempBuffer.toString().trim());
                    } else if (varName.compareToIgnoreCase("INPUTS") == 0 && inputResources != null) {
                        tempBuffer = new StringBuffer("");
                        int k = 0;
                        while (k < inputResources.length) {
                            if (!inputResources[k].equals("")) {
                                if (inputResources[k].indexOf("$(") != 0) {
                                    tempBuffer.append("\"" + inputResources[k] + "\"" + " ");
                                } else {
                                    this.appendInputResource(inputResources[k], tempBuffer);
                                }
                            }
                            ++k;
                        }
                        sb.append(tempBuffer.toString().trim());
                    } else {
                        sb.append("${" + varName + "}");
                    }
                }
                catch (Exception exception) {}
            }
            start = ++stop;
        }
        if (stop != -1 && stop < commandLinePattern.length()) {
            sb.append(commandLinePattern.substring(stop));
        }
        return this.createCommandLineInfo(commandName, flags, outputFlag, outputPrefix, outputName, inputResources, commandLinePattern, sb);
    }

    protected IManagedCommandLineInfo createCommandLineInfo(String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern, StringBuffer sb) {
        return new BaseManagedCommandLineInfo(sb.toString().trim(), commandLinePattern, commandName, this.stringArrayToString(flags), outputFlag, outputPrefix, outputName, this.stringArrayToString(inputResources));
    }

    protected void appendInputResource(String inputResources, StringBuffer tempBuffer) {
        tempBuffer.append(String.valueOf(inputResources) + " ");
    }

    protected String stringArrayToString(String[] array) {
        if (array == null || array.length <= 0) {
            return new String();
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            sb.append(String.valueOf(array[i]) + " ");
            ++i;
        }
        return sb.toString().trim();
    }

    public void setMakefileGenerator(CoreIDEMakefileGenerator coreIDEMakefileGenerator) {
        this.coreIDEMakefileGenerator = coreIDEMakefileGenerator;
    }

    protected CoreIDEMakefileGenerator getMakefileGenerator() {
        return this.coreIDEMakefileGenerator;
    }
}

