/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.imports;

import com.freescale.s32ds.cross.core.lingvo.Lingvo;
import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.Hardware;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class LaunchConfigUtil {
    private static final int MPC5777M_CORE_COUNT = 3;
    public static final Collection<HWModel> HWMODELS = Hardware.instance().getModels();
    public static final Lingvo LINGVO = new Lingvo();
    private static final String ATTR_PRJ_ATTR = "org.eclipse.cdt.launch.PROJECT_ATTR";
    private static final String ATTR_PRG_NAME = "org.eclipse.cdt.launch.PROGRAM_NAME";
    private static final String ATTR_PPC_DEV = "com.pemicro.debug.gdbjtag.ppc.PE.DEVICE_NAME";
    private static final String ATTR_PPC_NUM = "com.pemicro.debug.gdbjtag.ppc.selectedCoreNumber";
    private static final String ATTR_PNE_DEV = "com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME";
    private static final String ATTR_PNE_NUM = "com.pemicro.debug.gdbjtag.pne.selectedCoreNumber";
    private static final String ATTR_PNE_DEB = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";
    private static final String ATTR_SEG_DEV = "ilg.gnuarmeclipse.debug.gdbjtag.jlink.gdbServerDeviceName";
    private static final int NUM_NAMES = 2;
    private static final String[][] MPC_DATA;

    static {
        String[][] stringArrayArray = new String[5][];
        stringArrayArray[0] = new String[]{"MPC564", "C", "Z4", "Z0"};
        stringArrayArray[1] = new String[]{"MPC574", "G", "Z4", "Z4", "Z2"};
        stringArrayArray[2] = new String[]{"MPC577", "K", "Z4", "Z7", "Z7"};
        stringArrayArray[3] = new String[]{"MPC577", "M", "Z4", "Z7", "Z7"};
        String[] stringArray = new String[5];
        stringArray[0] = "S32R274";
        stringArray[2] = "Z4";
        stringArray[3] = "Z7";
        stringArray[4] = "Z7";
        stringArrayArray[4] = stringArray;
        MPC_DATA = stringArrayArray;
    }

    public static void setConfigurationDefaults(ILaunchConfigurationWorkingCopy config, IProject project, String programName, String deviceId, String procId, int coreNum) {
        if (LaunchConfigUtil.isSupportedPowerProcessor(procId)) {
            LaunchConfigUtil.setCommonProjectAttributes(config, project, programName);
            LaunchConfigUtil.setPowerAttributes(config, procId, coreNum);
        } else if (LaunchConfigUtil.isSupportedARMProcessor(procId)) {
            String proc = LINGVO.mapToLingvo(procId, "pemicro.Target");
            if (proc == null) {
                S32DSWizardPlugin.logWarning(String.format(Messages.ImportExeWizard_ArmIsNotInTheLingvo, new Object[0]));
                return;
            }
            LaunchConfigUtil.setCommonProjectAttributes(config, project, programName);
            LaunchConfigUtil.setArmAttributes(config, deviceId, procId, proc);
        } else {
            S32DSWizardPlugin.logWarning(String.format(Messages.ImportExeWizard_NeitherArmNorPower, procId));
        }
    }

    private static int getIndex(String proc, String procId) {
        String low = proc.toLowerCase();
        if (low.startsWith("s32v_cortexa53_a53")) {
            return 3;
        }
        if (low.startsWith("s32v_cortexm4")) {
            return 1;
        }
        if (low.startsWith("mac57d54h_m4")) {
            return 1;
        }
        if (low.startsWith("mac57d54h_a5")) {
            return 2;
        }
        if (low.startsWith("mac57d54h_m0plus")) {
            return 3;
        }
        if (low.startsWith("s9keaz")) {
            return -1;
        }
        if (low.startsWith("s32v234m100")) {
            return LaunchConfigUtil.getIndexForCoreFromHW(procId);
        }
        S32DSWizardPlugin.logWarning(Messages.bind((String)Messages.ImportExeWizard_UnknownArm, (Object)procId));
        return -1;
    }

    private static void setArmAttributes(ILaunchConfigurationWorkingCopy config, String deviceId, String procId, String proc) {
        config.setAttribute(ATTR_SEG_DEV, LINGVO.mapToLingvo(procId, "segger.Target"));
        String debug = "${cross_prefix}gdb${cross_suffix}";
        if (proc.toLowerCase().startsWith("s32v_cortexa53_a53")) {
            debug = "${cortexa_cross_prefix}gdb${cross_suffix}";
        }
        int index = LaunchConfigUtil.getIndex(proc, procId);
        config.setAttribute(ATTR_PNE_NUM, index);
        config.setAttribute(ATTR_PNE_DEB, debug);
        String fam = LaunchConfigUtil.modifyFamily(deviceId);
        String device_name = "NXP_" + fam + '_' + proc;
        config.setAttribute(ATTR_PNE_DEV, device_name);
    }

    private static void setPowerAttributes(ILaunchConfigurationWorkingCopy config, String procId, int assumedCoreNum) {
        if ("MPC5777M".equals(procId)) {
            assumedCoreNum = 3 - assumedCoreNum;
        }
        if (assumedCoreNum <= 0) {
            assumedCoreNum = 1;
        }
        config.setAttribute(ATTR_PPC_DEV, procId);
        config.setAttribute(ATTR_PPC_NUM, assumedCoreNum);
    }

    private static void setCommonProjectAttributes(ILaunchConfigurationWorkingCopy config, IProject project, String programName) {
        config.setContainer((IContainer)project.getProject());
        config.setMappedResources(new IResource[]{project.getProject()});
        config.setAttribute(ATTR_PRJ_ATTR, project.getProject().getName());
        config.setAttribute(ATTR_PRG_NAME, programName);
        config.setAttribute("process_factory_id", "org.eclipse.cdt.dsf.gdb.GdbProcessFactory");
    }

    public static int getIndexForCoreFromHW(String id) {
        return id == null ? 1 : HWMODELS.stream().map(HWModel::getProcessors).flatMap(Collection::stream).filter(c -> id.equals(c.getId())).collect(Collectors.toList()).stream().map(ProcessorData::getCores).flatMap(Collection::stream).findFirst().map(c -> c.getIntValue("index", 1)).orElse(1);
    }

    public static int calcCoreIndex(String proc, String core) {
        if (proc != null && core != null) {
            proc = proc.toUpperCase();
            core = core.toUpperCase();
            String[][] stringArray = MPC_DATA;
            int n = MPC_DATA.length;
            int n2 = 0;
            while (n2 < n) {
                String[] data = stringArray[n2];
                if (proc.startsWith(data[0]) && (data[1] == null || proc.endsWith(data[1]))) {
                    int i = 2;
                    while (i < data.length) {
                        if (core.equals(data[i])) {
                            return --i;
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        return 1;
    }

    private static String modifyFamily(String f) {
        if (f.startsWith("SKEA") || f.startsWith("KEA")) {
            return "KEx";
        }
        if (f.startsWith("S32K")) {
            return "S32K1xx";
        }
        if (f.startsWith("S32V")) {
            return "S32Vxxx";
        }
        if (f.startsWith("MAC57D5")) {
            return "MAC57D5xx";
        }
        return f;
    }

    private static boolean isSupportedARMProcessor(String proc) {
        if (proc == null || proc.isEmpty()) {
            return false;
        }
        return (proc = proc.toLowerCase().trim()).startsWith("skeaz") || proc.startsWith("keaz") || proc.startsWith("mac") || proc.startsWith("s32k") || proc.startsWith("s32v");
    }

    private static boolean isSupportedPowerProcessor(String proc) {
        if (proc == null || proc.isEmpty()) {
            return false;
        }
        return (proc = proc.toLowerCase().trim()).startsWith("mpc") || proc.startsWith("s32r");
    }
}

