/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license.cll;

import com.nxp.s32ds.ext.rcp.license.IFeatureId;
import com.nxp.s32ds.ext.rcp.license.ILicenseModel;
import com.nxp.s32ds.ext.rcp.license.LicenseActivator;
import com.nxp.s32ds.ext.rcp.license.LicenseStatus;
import com.nxp.s32ds.ext.rcp.license.cll.CLLFeatureDetail;
import com.nxp.s32ds.ext.rcp.license.cll.CLLFeatureId;
import com.nxp.s32ds.ext.rcp.license.cll.CLLModel;
import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import com.nxp.s32ds.ext.rcp.license.cll.LicenseException;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class CLLCertificateModel
implements ILicenseModel {
    private static final String PARAM_LICANSE_PATH = "licensePath";
    private final ICLL cll = CLLModel.instanceCLL();
    private Map<String, String> params;
    private int evaluationWarningDays = 7;

    @Override
    public String getModelDetails() {
        return "CLL License " + this.params;
    }

    @Override
    public LicenseStatus getStatus(IFeatureId licenseFeatureId) {
        CLLFeatureDetail f = this.getBestFor((CLLFeatureId)licenseFeatureId);
        if (f == null) {
            return LicenseStatus.MISSED;
        }
        if ("FOREVER".equals(f.getDaysToExpire())) {
            return LicenseStatus.ACTIVATED;
        }
        if (Integer.parseInt(f.getDaysToExpire()) < 1) {
            return LicenseStatus.EXPIRED;
        }
        if (f.getExpirationDate() != null) {
            return LicenseStatus.EVALUATION;
        }
        return LicenseStatus.ACTIVATED;
    }

    private CLLFeatureDetail getBestFor(CLLFeatureId fid) {
        CLLFeatureDetail f = this.cll.listFeatures(fid.getProductName(), fid.getFeatureId(), fid.getVersion(), new CLLReason());
        if (f != null && f.getNext() != null) {
            if ("FOREVER".equals(f.getDaysToExpire())) {
                return f;
            }
            long maxDays = Long.parseLong(f.getDaysToExpire());
            CLLFeatureDetail best = f;
            CLLFeatureDetail cur = f;
            while (cur.getNext() != null) {
                if ("FOREVER".equals((cur = cur.getNext()).getDaysToExpire())) {
                    return cur;
                }
                long curDays = Long.parseLong(cur.getDaysToExpire());
                if (maxDays >= curDays) continue;
                maxDays = curDays;
                best = cur;
            }
            return best;
        }
        return f;
    }

    @Override
    public void activate(String id, Map<String, String> params) throws LicenseException {
        throw new LicenseException("File-based license can't be activated from UI");
    }

    @Override
    public void init(Map<String, String> params, Set<String> products) throws Exception {
        this.params = params;
        this.checkParams(params, PARAM_LICANSE_PATH);
        IStringVariableManager vmng = VariablesPlugin.getDefault().getStringVariableManager();
        String pathToLicenseFile = vmng.performStringSubstitution(params.get(PARAM_LICANSE_PATH));
        this.cll.setLicenseLocation(pathToLicenseFile, null, 0);
        this.evaluationWarningDays = params.containsKey("intNumberOfDays") ? Integer.parseInt(params.get("intNumberOfDays")) : 7;
    }

    private void checkParams(Map<String, String> params, String ... reqParams) throws Exception {
        String[] stringArray = reqParams;
        int n = reqParams.length;
        int n2 = 0;
        while (n2 < n) {
            String paramName = stringArray[n2];
            if (!params.containsKey(paramName)) {
                throw new Exception("license model parameter missing: " + paramName);
            }
            ++n2;
        }
    }

    @Override
    public int getEvaluationDays(IFeatureId licenseFeatureId) {
        CLLFeatureDetail f = this.getBestFor((CLLFeatureId)licenseFeatureId);
        if (f == null) {
            return 0;
        }
        if ("FOREVER".equals(f.getDaysToExpire())) {
            return 3650000;
        }
        return Integer.parseInt(f.getDaysToExpire());
    }

    @Override
    public int getEvaluationWarningDays() {
        return this.evaluationWarningDays;
    }

    @Override
    public String getActivationId(IFeatureId licenseFeatureId) {
        CLLFeatureDetail f = this.getBestFor((CLLFeatureId)licenseFeatureId);
        if (f != null) {
            return f.getActivationID();
        }
        return "";
    }

    @Override
    public String getFeatureDetails(IFeatureId licenseFeatureId) {
        CLLFeatureId fId = (CLLFeatureId)licenseFeatureId;
        CLLFeatureDetail f = this.getBestFor(fId);
        if (f != null) {
            return f.toString();
        }
        return "feature " + fId.getFeatureId() + " " + fId.getVersion() + " is missing";
    }

    @Override
    public IFeatureId createFeatureId(Map<String, String> params) {
        return new CLLFeatureId(params.get("productName"), params.get("featureId"), params.get("featureVersion"));
    }

    @Override
    public void refreshFeature(IFeatureId id) {
        LicenseActivator.log(2, "File license unsupport refresh", new IllegalStateException());
    }

    @Override
    public boolean isTestMode() {
        return false;
    }

    @Override
    public void returnFeature(String id, Map<String, String> params) throws LicenseException {
        LicenseActivator.log(2, "File license unsupport return", new IllegalStateException());
    }

    public static void main(String[] args) {
        CLLReason reason;
        CLLFeatureDetail cur;
        CLLCertificateModel cllCert = new CLLCertificateModel();
        CLLReason resultLocation = cllCert.cll.setLicenseLocation("C:\\000\\testLic.lic", null, 0);
        if (resultLocation != null && resultLocation.isError()) {
            System.out.println(resultLocation);
            System.exit(1);
        }
        if ((cur = cllCert.cll.listFeatures(null, null, null, reason = new CLLReason())) != null) {
            System.out.println(cur);
        } else if (reason.isError()) {
            System.err.print(reason);
        }
        CLLFeatureId licenseFeatureId = new CLLFeatureId("testTool", "testFeature", "2.0");
        System.out.println((Object)cllCert.getStatus(licenseFeatureId));
    }
}

