/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.IExternalSDK;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.internal.AbstractSDK;
import com.freescale.s32ds.cross.sdk.internal.ExternalSDKFilter;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class ExternalSDK
extends AbstractSDK
implements IExternalSDK {
    private static final String EXTERNAL_SDKS_PREF_KEY = String.valueOf(SDKSupportPlugin.getUniqueIdentifier()) + ".externalSDKs";
    private static final String[] TC_ARR = new String[]{"Copy"};

    public ExternalSDK(SDKHeader head, TCHolder root, IFilterOptions filterOptions) {
        super(head, root, filterOptions, null);
        this.type = ISDK.TYPE.EXTERNAL;
    }

    @Override
    public void setHeader(SDKHeader h) {
        this.head = h;
    }

    @Override
    public void setPaths(TCHolder h) {
        this.root = h;
    }

    @Override
    public void setFilterOptions(IFilterOptions filterOptions) {
        this.filterOptions = filterOptions;
    }

    @Override
    public ISDK.STATUS getStatus() {
        return ISDK.STATUS.EXTERNAL;
    }

    public static void loadExternalPersistedSDKs() {
        String sdksString = Platform.getPreferencesService().getString(SDKSupportPlugin.getUniqueIdentifier(), EXTERNAL_SDKS_PREF_KEY, "", null);
        ExternalSDK.parseSDKsString(sdksString, null, 4);
    }

    public static void storeExternalSDKs() {
        try {
            IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(SDKSupportPlugin.getUniqueIdentifier());
            prefs.put(EXTERNAL_SDKS_PREF_KEY, ExternalSDK.getSDKsString(ExternalSDK.getExternalSDKs()));
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            SDKSupportPlugin.error(bse);
        }
    }

    private static List<ISDK> getExternalSDKs() {
        return SDKUtils.filter(new ExternalSDKFilter());
    }

    @Override
    public String[] getToolChainIDs() {
        String id = this.root.getTCId();
        if ((id == null || id.isEmpty()) && this.toolchains != null && this.toolchains.length == 1) {
            id = this.toolchains[0].getTCId();
        }
        if (id == null || id.isEmpty() && this.head.obsoleteToolchainIds != null) {
            id = this.head.obsoleteToolchainIds;
        }
        return id == null || id.isEmpty() ? ZERO_ARR : id.split(",");
    }

    @Override
    public String[] getToolChainAliases() {
        return TC_ARR;
    }

    @Override
    public void setPaths(IExtendedPath[] src, IExtendedPath[] hdr, IExtendedPath[] bin, IExtendedPath[] oth, IExtendedPath[] ld, String[] def) {
        this.root.srcs = Arrays.asList(src);
        this.root.hdrs = Arrays.asList(hdr);
        this.root.bins = Arrays.asList(bin);
        this.root.oths = Arrays.asList(oth);
        this.root.ldfs = Arrays.asList(ld);
        this.root.defs = Arrays.asList(def);
    }

    @Override
    public IExtendedPath[][] getAll(int mode) {
        IExtendedPath[][] res = new IExtendedPath[][]{this.union(this.root, this.toolchains, mode, "all_toolchains")};
        return res;
    }

    @Override
    public String[][] getDefSymbols() {
        String[][] res = new String[][]{this.getDefSymbols("all_toolchains")};
        return res;
    }
}

