/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.dialogs;

import com.nxp.s32ds.ext.ide.internal.resources.ResourcesMessages;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectSelectionDialog
extends ElementTreeSelectionDialog {
    public ProjectSelectionDialog(Shell parent) {
        super(parent, WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (ITreeContentProvider)new ProjectsTreeContentProvider());
        this.setMessage(ResourcesMessages.ProjectSelectionDialog_select_target_project);
        this.setInput(this.computeInput());
    }

    public ProjectSelectionDialog(Shell parent, String title) {
        super(parent, WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (ITreeContentProvider)new ProjectsTreeContentProvider());
        this.setDialogTitle(title);
        this.setMessage(ResourcesMessages.ProjectSelectionDialog_select_target_project);
        this.setInput(this.computeInput());
    }

    public void setDialogTitle(String title) {
        this.setTitle(title);
    }

    private Object[] computeInput() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(1, null);
        }
        catch (CoreException e) {
            this.setMessage(e.getMessage());
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> openProjects = new ArrayList<IProject>(projects.length);
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen()) {
                openProjects.add(projects[i]);
            }
            ++i;
        }
        return openProjects.toArray(new IProject[openProjects.size()]);
    }

    public IProject getSelectedProject() {
        Object[] result = this.getResult();
        if (result != null) {
            return (IProject)result[0];
        }
        return null;
    }

    private static class ProjectsTreeContentProvider
    implements ITreeContentProvider {
        private ProjectsTreeContentProvider() {
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public Object[] getElements(Object input) {
            ArrayList<Object> inputFiltered = new ArrayList<Object>();
            Object[] objectArray = (Object[])input;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object it = objectArray[n2];
                if (it instanceof IProject) {
                    inputFiltered.add(it);
                }
                ++n2;
            }
            return inputFiltered.toArray(new Object[inputFiltered.size()]);
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }
    }
}

