/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.utils;

import com.nxp.s32ds.ext.ide.core.refactoring.IRenameParticipant;
import com.nxp.s32ds.ext.ide.examples.core.ProjectSet;
import com.nxp.s32ds.ext.ide.examples.core.ValidationExampleUtil;
import com.nxp.s32ds.ext.ide.examples.ui.internal.ExIdtUiExamplesActivator;
import com.nxp.s32ds.ext.ide.ui.utils.OverwriteQueryImpl;
import com.nxp.s32ds.ext.ide.utils.OSFamily;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.osgi.service.prefs.BackingStoreException;

public class RenameOperationContext {
    private static final String PREF_WIZARD = "com.freescale.s32ds.cross.wizard";
    private static final String GROUP_NAME = "groupName";
    public static final String EMPTY = "";
    private final String userProjectName;
    private final ProjectSet projectsGroup;
    private final Map<String, String> nameMap;
    private List<IRenameParticipant> lstParticipants;

    public RenameOperationContext(String userProjectName, ProjectSet projects, List<IRenameParticipant> lstParticipants) {
        this.userProjectName = userProjectName;
        this.projectsGroup = projects;
        this.nameMap = Collections.unmodifiableMap(Stream.concat(projects.getProjects().map(IProjectDescription::getName), Stream.of(projects.getName())).distinct().collect(Collectors.toMap(String::toString, ValidationExampleUtil.replaceAllQuoted((String)("^" + Pattern.quote(projects.getName())), (String)userProjectName))));
        this.lstParticipants = lstParticipants;
    }

    public IProject performProjectOperation(IProjectDescription project, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException, BackingStoreException {
        Path newPath;
        RenameOperationContext.unHide(project);
        if (this.userProjectName.equals(this.projectsGroup.getName())) {
            newPath = new Path(String.valueOf(this.projectsGroup.getName()) + '/' + project.getName());
        } else {
            String previusProjectName = project.getName();
            String currentProjectName = previusProjectName.replace(this.projectsGroup.getName(), this.userProjectName);
            newPath = new Path(String.valueOf(this.userProjectName) + '/' + currentProjectName);
        }
        String newProjectName = this.nameMap.get(project.getName());
        IProject newProject = ValidationExampleUtil.toProject((String)newProjectName);
        IProjectDescription newProjectDecsr = RenameOperationContext.copy(project, newProjectName, newPath.toString());
        newProject.create(newProjectDecsr, monitor);
        newProject.open(128, monitor);
        RenameOperationContext.importSource(newProject, project.getLocation().toFile(), monitor);
        RenameOperationContext.unHide(newProject.getDescription());
        this.invokeParticipants(newProject, monitor);
        this.updateProjectPreferences(newProject);
        return newProject;
    }

    private void updateProjectPreferences(IProject newProject) throws BackingStoreException {
        IEclipsePreferences prefs = new ProjectScope(newProject).getNode(PREF_WIZARD);
        prefs.put(GROUP_NAME, this.getName(prefs.get(GROUP_NAME, EMPTY)));
        prefs.flush();
    }

    private static IProjectDescription copy(IProjectDescription src, String name, String path) {
        IProjectDescription dst = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        dst.setLocation(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(path));
        dst.setBuildSpec(src.getBuildSpec());
        dst.setComment(src.getComment());
        dst.setDynamicReferences(src.getDynamicReferences());
        dst.setNatureIds(src.getNatureIds());
        dst.setReferencedProjects(src.getReferencedProjects());
        return dst;
    }

    private void invokeParticipants(IProject resource, IProgressMonitor monitor) {
        String oldNamePart = this.projectsGroup.getName();
        String newNamePart = this.userProjectName;
        for (IRenameParticipant iter : this.lstParticipants) {
            iter.renameProject(resource, oldNamePart, newNamePart, monitor);
        }
    }

    private String getName(String key) {
        return this.nameMap.getOrDefault(key, key);
    }

    private static void importSource(IProject project, File importSource, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
        OverwriteQueryImpl owRenameQuery = new OverwriteQueryImpl();
        ImportOperation impOperation = new ImportOperation(project.getFullPath(), (Object)importSource, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)owRenameQuery, FileSystemStructureProvider.INSTANCE.getChildren((Object)importSource));
        impOperation.setOverwriteResources(true);
        impOperation.setCreateContainerStructure(false);
        impOperation.run(monitor);
        IStatus result = impOperation.getStatus();
        if (!result.isOK()) {
            throw new CoreException(result);
        }
    }

    private static void unHide(IProjectDescription project) {
        File f;
        if (OSFamily.WINDOWS.isCurrent() && (f = new File(new File(project.getLocationURI()), ".project")).isHidden()) {
            try {
                Files.setAttribute(f.toPath(), "dos:hidden", false, new LinkOption[0]);
            }
            catch (IOException e) {
                ExIdtUiExamplesActivator.info("UNSET HIDDEN ERROR: " + e);
            }
        }
    }
}

