/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core;

import com.nxp.s32ds.ext.cdt.internal.core.CoreMessages;
import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class CdtCore {
    public static final String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.ext.cdt.core";

    public static void createSourceFolder(String projectName, String targetPath, IProgressMonitor monitor) throws CoreException {
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFolder folder = WorkspaceResources.createFolder((IProject)projectHandle, (String)targetPath, (IProgressMonitor)monitor);
        try {
            ICProject cProject = CoreModel.getDefault().create(projectHandle);
            if (cProject != null) {
                if (CCorePlugin.getDefault().isNewStyleProject(cProject.getProject())) {
                    CdtCore.createSourceFolderNewStyle(projectHandle, folder, monitor);
                } else {
                    IPath projPath = projectHandle.getFullPath();
                    CdtCore.createSourceFolder(cProject, projPath, targetPath, monitor);
                }
            }
        }
        catch (WriteAccessException e) {
            String message = NLS.bind((String)CoreMessages.CdtCore_e_creating_source_folder, (Object)targetPath, (Object)e.getMessage());
            Status error = new Status(4, BUNDLE_SYMBOLIC_NAME, message, (Throwable)e);
            throw new CoreException((IStatus)error);
        }
        catch (CoreException e) {
            throw e;
        }
    }

    private static void createSourceFolder(ICProject cProject, IPath projPath, String targetPath, IProgressMonitor monitor) throws CModelException {
        IPathEntry[] entries = cProject.getRawPathEntries();
        ArrayList<Object> newEntries = new ArrayList<Object>(entries.length + 1);
        int projectEntryIndex = -1;
        IPath path = projPath.append(targetPath);
        int i = 0;
        while (i < entries.length) {
            IPathEntry curr = entries[i];
            if (path.equals((Object)curr.getPath())) {
                return;
            }
            if (projPath.equals((Object)curr.getPath())) {
                projectEntryIndex = i;
            }
            newEntries.add(curr);
            ++i;
        }
        ISourceEntry newEntry = CoreModel.newSourceEntry((IPath)path);
        if (projectEntryIndex != -1) {
            newEntries.set(projectEntryIndex, newEntry);
        } else {
            newEntries.add(CoreModel.newSourceEntry((IPath)path));
        }
        cProject.setRawPathEntries(newEntries.toArray(new IPathEntry[newEntries.size()]), monitor);
    }

    private static void createSourceFolderNewStyle(IProject projectHandle, IFolder folder, IProgressMonitor monitor) throws CoreException, WriteAccessException {
        CSourceEntry newEntry = new CSourceEntry(folder, null, 0);
        ICProjectDescription description = CCorePlugin.getDefault().getProjectDescription(projectHandle);
        ICConfigurationDescription[] configs = description.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            ICConfigurationDescription config = configs[i];
            ICSourceEntry[] entries = config.getSourceEntries();
            HashSet<Object> set = new HashSet<Object>();
            int j = 0;
            while (j < entries.length) {
                if (new Path(entries[j].getValue()).segmentCount() != 1) {
                    set.add(entries[j]);
                }
                ++j;
            }
            set.add(newEntry);
            config.setSourceEntries(set.toArray(new ICSourceEntry[set.size()]));
            ++i;
        }
        CCorePlugin.getDefault().setProjectDescription(projectHandle, description, false, monitor);
    }
}

