/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core;

import com.freescale.s32ds.cdt.core.FSLCCorePlugin;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;

public class ActiveProjectDecorator
implements ILightweightLabelDecorator,
IWindowListener,
IPartListener {
    private final Font activeFont = (Font)new AtomicReference<Font>(){
        {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    this.set(FontDescriptor.createFrom((Font)Display.getDefault().getSystemFont()).setStyle(1).createFont((Device)Display.getDefault()));
                }
            });
        }
    }.get();
    private final Set<ILabelProviderListener> listeners = new HashSet<ILabelProviderListener>();
    private IProject active = null;

    public ActiveProjectDecorator() {
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
    }

    public IProject getActive() {
        return this.active;
    }

    private void setActive(IProject newActive) {
        this.active = newActive;
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.windowOpened(window);
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener)this);
        this.partActivated(window.getPartService().getActivePart());
    }

    public void windowDeactivated(IWorkbenchWindow window) {
        this.windowClosed(window);
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.getPartService().removePartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
        IResource resource = null;
        try {
            if (part instanceof IEditorPart) {
                IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
                resource = ResourceUtil.getResource((IEditorInput)editorInput);
            }
        }
        catch (Exception e) {
            FSLCCorePlugin.log(e);
        }
        this.setActive(resource != null ? resource.getProject() : null);
    }

    private void fireLabelProviderChanged(LabelProviderChangedEvent event) {
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(event);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
        this.activeFont.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element.equals(this.active)) {
            decoration.setFont(this.activeFont);
        }
    }
}

