/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core;

import com.freescale.s32ds.cdt.core.FSLCCorePlugin;
import com.freescale.s32ds.cdt.core.Messages;
import com.freescale.s32ds.cdt.core.OSFamily;
import com.nxp.s32ds.ext.rcp.jse.utils.FuncUtils;
import java.io.File;
import java.net.URL;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchWindow;

public class EclipseUtils {
    public static final String PROPERTY_OS_NAME = "os.name";
    public static final String PROPERTY_OS_ARCH = "os.arch";
    public static final String FORBIDDEN_CHARS = "#;=,:@*?<>\\|\"' {}[]()`&$%";
    public static final String EMPTY = "";
    private static final int STRING_MAX_LENGTH = 250;

    public static boolean isWindowsXP() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().equalsIgnoreCase("Windows XP");
    }

    public static boolean isWindows64() {
        if (System.getProperty(PROPERTY_OS_NAME).contains("Windows")) {
            return System.getenv("ProgramFiles(x86)") != null;
        }
        return System.getProperty(PROPERTY_OS_ARCH).indexOf("64") != -1;
    }

    public static String getPathSeparator() {
        return OSFamily.WINDOWS.isCurrent() ? ";" : ":";
    }

    public static void openExternalBrowser(URL url) throws PartInitException {
        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
    }

    public static void openExternalFile(IPath path) throws PartInitException {
        IDE.openEditorOnFileStore((IWorkbenchPage)EclipseUtils.getActivePage(), (IFileStore)EFS.getLocalFileSystem().getStore(path));
    }

    public static void openFileWithInternalEditor(IPath path) throws PartInitException {
        IDE.openInternalEditorOnFileStore((IWorkbenchPage)EclipseUtils.getActivePage(), (IFileStore)EFS.getLocalFileSystem().getStore(path));
    }

    public static IProject getProjectByName(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public static IProject getSelectedProject() {
        Object firstElement;
        ISelection selection;
        IWorkbenchWindow window = EclipseUtils.getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) != null && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IProject project = (IProject)((IAdaptable)firstElement).getAdapter(IProject.class);
            return project;
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        return EclipseUtils.getActiveWorkbenchWindow().getActivePage();
    }

    public static IWorkbenchPage getActivePage(IWorkbenchPart part) {
        return part.getSite().getWorkbenchWindow().getActivePage();
    }

    public static Shell getShell() {
        return EclipseUtils.getActiveWorkbenchWindow().getShell();
    }

    public static IConfiguration getConfigurationFromDescription(ICConfigurationDescription configDescription) {
        return ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configDescription);
    }

    public static void openError(String title, String message, Exception e) {
        FSLCCorePlugin.log(String.valueOf(title) + " -> " + message);
    }

    private static Runnable setStatusLineMessage(String message) {
        return () -> {
            IWorkbenchWindow window = EclipseUtils.getActiveWorkbenchWindow();
            if (window instanceof WorkbenchWindow) {
                ((WorkbenchWindow)window).getStatusLineManager().setErrorMessage(message);
            }
        };
    }

    private static IWorkbenchWindow getActiveWorkbenchWindow() {
        Assert.isNotNull((Object)Display.getCurrent(), (String)"getActiveWorkbenchWindow() is called from a non-UI thread");
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static void clearStatusMessage() {
        Display.getDefault().syncExec(EclipseUtils.setStatusLineMessage(EMPTY));
    }

    public static void showStatusMessage(String message) {
        FSLCCorePlugin.log(message);
        Display.getDefault().asyncExec(EclipseUtils.setStatusLineMessage(message));
    }

    public static void showStatusErrorMessage(String message) {
        FSLCCorePlugin.log((IStatus)new Status(2, "com.freescale.s32ds.cdt.core", message));
        Display.getDefault().asyncExec(EclipseUtils.setStatusLineMessage("  " + message));
    }

    public static String getPreferenceValueForId(String pluginId, String key, String defaultValue, IScopeContext[] contexts) {
        return Stream.of(contexts).map(c -> c.getNode(pluginId).get(key, null)).filter(Objects::nonNull).map(String::trim).filter(FuncUtils.not(String::isEmpty)).findAny().orElse(defaultValue);
    }

    public static IScopeContext[] getPreferenceScopeContexts(IProject project) {
        return (IScopeContext[])Stream.concat(project == null ? Stream.of(new IScopeContext[0]) : Stream.of(new ProjectScope(project)), Stream.of(InstanceScope.INSTANCE, ConfigurationScope.INSTANCE, DefaultScope.INSTANCE)).toArray(IScopeContext[]::new);
    }

    public static String getPreferenceValueForId(String pluginId, String key, String defaultValue, IProject project) {
        return EclipseUtils.getPreferenceValueForId(pluginId, key, defaultValue, EclipseUtils.getPreferenceScopeContexts(project));
    }

    private static String checkForSymbols(String name, String object) {
        if (name == null || name.trim().length() == 0) {
            return String.format(Messages.EclipseUtils_name_empty, object);
        }
        StringBuilder sb = new StringBuilder();
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (FORBIDDEN_CHARS.chars().anyMatch(x -> c == x)) {
                sb.append(c);
                break;
            }
            ++n2;
        }
        if (sb.length() > 0) {
            return String.format(Messages.EclipseUtils_bad_symbols, object, sb.toString());
        }
        if (name.length() > 250) {
            return String.format(Messages.EclipseUtils_too_large, object);
        }
        return null;
    }

    public static IStatus checkProjectName(String name, boolean full) {
        String object = full ? Messages.EclipseUtils_Project : Messages.EclipseUtils_Directory;
        String err = EclipseUtils.checkForSymbols(name, object);
        if (err != null) {
            return new Status(4, "com.freescale.s32ds.cdt.core", err);
        }
        if (full) {
            char first = name.charAt(0);
            if (!Character.isLetter(first) && !Character.isDigit(first)) {
                return new Status(4, "com.freescale.s32ds.cdt.core", String.format(Messages.EclipseUtils_first_letter, object, Character.valueOf(first)));
            }
            IWorkspace wsp = ResourcesPlugin.getWorkspace();
            IStatus status = wsp.validateName(name, 4);
            if (!status.isOK()) {
                return status;
            }
            if (wsp.getRoot().getProject(name).exists()) {
                return new Status(4, "com.freescale.s32ds.cdt.core", Messages.EclipseUtils_name_equal);
            }
            IProject[] iProjectArray = wsp.getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (name.equalsIgnoreCase(p.getName())) {
                    return new Status(4, "com.freescale.s32ds.cdt.core", String.format(Messages.EclipseUtils_name_similar, p.getName()));
                }
                ++n2;
            }
            File f = new File(wsp.getRoot().getLocationURI());
            File[] fileArray = f.listFiles(file -> name.equalsIgnoreCase(file.getName()));
            if (fileArray.length != 0) {
                File ff = fileArray[0];
                return new Status(4, "com.freescale.s32ds.cdt.core", String.format(String.format(Messages.EclipseUtils_already_exists, ff.isDirectory() ? Messages.EclipseUtils_dir : Messages.EclipseUtils_file, ff.getName()), new Object[0]));
            }
        }
        return Status.OK_STATUS;
    }

    public static String readExternalSetting(String key, IProject project, ICConfigurationDescription cfg) {
        ICProjectDescription desc = CoreModel.getDefault().getProjectDescription(project, false);
        cfg = cfg == null ? desc.getActiveConfiguration() : cfg;
        return Stream.of(cfg.getExternalSettings()).map(ICExternalSetting::getEntries).flatMap(iCSettingEntryArray -> Stream.of(iCSettingEntryArray)).filter(e -> e.getName().equals(key)).map(ICSettingEntry::getValue).findAny().orElse(null);
    }

    public static String readExternalSetting(String key, IProject project) {
        return EclipseUtils.readExternalSetting(key, project, null);
    }
}

