/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.internal.commanderview.view;

import com.freescale.s32ds.cdt.core.commanderview.ICommandHandler;
import com.freescale.s32ds.cdt.core.internal.commanderview.Activator;
import com.freescale.s32ds.cdt.core.internal.commanderview.handlers.CmdBridgeHandler;
import com.freescale.s32ds.cdt.core.internal.commanderview.handlers.OpenViewHandler;
import com.freescale.s32ds.cdt.core.internal.commanderview.view.CommandManager;
import com.freescale.s32ds.cdt.core.internal.commanderview.view.SafeRunnable;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;

public class CommandExtension {
    private static final String EXTENSION_POINT_ID = "com.freescale.s32ds.cdt.core.commanderview.commands";
    private static final GroupElement[] EMPTY_GROUPS = new GroupElement[0];
    private static final CommandElement[] EMPTY_COMMANDS = new CommandElement[0];

    static GroupElement[] getContibutedGroups() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        if (configs == null) {
            return EMPTY_GROUPS;
        }
        ArrayList<GroupElement> groupElements = new ArrayList<GroupElement>(10);
        IConfigurationElement[] iConfigurationElementArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            if (config.getName().equals("group")) {
                String id = config.getAttribute("id");
                String label = config.getAttribute("label");
                GroupElement element = new GroupElement();
                element.group = new CommandManager.Group(id, label);
                element.after = config.getAttribute("after");
                groupElements.add(element);
            }
            ++n2;
        }
        return groupElements.toArray(new GroupElement[groupElements.size()]);
    }

    static CommandElement[] getContibutedCommands(boolean supportedOnly) {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        if (configs == null) {
            return EMPTY_COMMANDS;
        }
        ArrayList<CommandElement> cmdElements = new ArrayList<CommandElement>(10);
        IConfigurationElement[] iConfigurationElementArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                ICommandHandler handler;
                String defaultShow;
                String parent;
                String keyBindingCmdId;
                String keyBinding;
                String after;
                String image;
                String tooltip;
                String description;
                String label;
                String group;
                String id;
                IConfigurationElement config;
                block21: {
                    block22: {
                        String viewId;
                        block20: {
                            String platformCmdId;
                            block16: {
                                block19: {
                                    block18: {
                                        config = iConfigurationElementArray[n2];
                                        if (!config.getName().equals("command")) break block17;
                                        id = config.getAttribute("id");
                                        group = config.getAttribute("group");
                                        label = config.getAttribute("label");
                                        description = config.getAttribute("description");
                                        tooltip = config.getAttribute("tooltip");
                                        image = config.getAttribute("image");
                                        after = config.getAttribute("after");
                                        keyBinding = config.getAttribute("keyBindingChar");
                                        keyBindingCmdId = config.getAttribute("keyBindingCommandId");
                                        parent = config.getAttribute("parent");
                                        defaultShow = config.getAttribute("defaultShow");
                                        if (id != null) break block18;
                                        Activator.log(4, String.format("Plug-in %s has contributed a Commander view command without an ID", config.getContributor().getName()), null);
                                        break block17;
                                    }
                                    if (group != null && label != null) break block19;
                                    Activator.log(4, String.format("Commander view command '%s' lacks one or more required attributes", id), null);
                                    break block17;
                                }
                                platformCmdId = null;
                                viewId = null;
                                handler = null;
                                IConfigurationElement[] children = config.getChildren("custom");
                                if (children.length > 0) {
                                    try {
                                        handler = (ICommandHandler)children[0].createExecutableExtension("class");
                                        break block16;
                                    }
                                    catch (CoreException exc) {
                                        Activator.log(exc);
                                        break block17;
                                    }
                                }
                                children = config.getChildren("platformCommand");
                                if (children.length > 0) {
                                    platformCmdId = children[0].getAttribute("cmdId");
                                } else {
                                    children = config.getChildren("openView");
                                    if (children.length > 0) {
                                        viewId = children[0].getAttribute("viewId");
                                    }
                                }
                            }
                            if (platformCmdId == null) {
                                platformCmdId = config.getAttribute("platformCommandId");
                            }
                            if (platformCmdId == null) break block20;
                            handler = new CmdBridgeHandler(platformCmdId);
                            break block21;
                        }
                        if (viewId == null) break block22;
                        handler = new OpenViewHandler(viewId);
                        break block21;
                    }
                    if (handler == null) {
                        try {
                            handler = (ICommandHandler)config.createExecutableExtension("class");
                        }
                        catch (CoreException exc) {
                            Activator.log(exc);
                            break block17;
                        }
                    }
                    if (!supportedOnly) break block21;
                    final boolean[] supported = new boolean[1];
                    final ICommandHandler _handler = handler;
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void run() throws Exception {
                            supported[0] = _handler.supported();
                        }
                    });
                    if (!supported[0]) break block17;
                }
                CommandElement element = new CommandElement();
                element.command = new CommandManager.Command(config.getNamespaceIdentifier(), id, label, handler, image, tooltip, description, Boolean.TRUE.toString().equals(defaultShow) || defaultShow == null, keyBinding != null ? Character.valueOf(keyBinding.charAt(0)) : null, keyBindingCmdId);
                element.group = group;
                element.after = after;
                element.parent = parent;
                cmdElements.add(element);
            }
            ++n2;
        }
        return cmdElements.toArray(new CommandElement[cmdElements.size()]);
    }

    static class CommandElement {
        CommandManager.Command command;
        String group;
        String after;
        public String parent;

        CommandElement() {
        }
    }

    static class GroupElement {
        CommandManager.Group group;
        String after;

        GroupElement() {
        }
    }
}

