/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.IFileFilter;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Path;

public class ExtendedPath
extends Path
implements IExtendedPath {
    private static boolean silentMode = false;
    private static final File[] EMPTY_FILES = new File[0];
    private boolean isCopy;
    private boolean isOverride;
    private String copyPath;
    private final boolean isDir;
    private boolean isPublic = false;
    private boolean toOpen = false;
    private String renameTo = null;
    private final Map<PathMatcher, IExtendedPath[]> matchedPlainCache = new HashMap<PathMatcher, IExtendedPath[]>();
    private final Map<PathMatcher, IExtendedPath[]> matchedRecursiveCache = new HashMap<PathMatcher, IExtendedPath[]>();

    public static IExtendedPath fromOSString(String pathString, boolean isDirectory) {
        return ExtendedPath.fromOSString(pathString, false, null, null, Boolean.FALSE, Boolean.FALSE, isDirectory);
    }

    public static IExtendedPath fromOSString(String pathString, boolean isCopy, String copyPath, String renameTo, Boolean isPublic, Boolean toOpen, boolean isDir) {
        pathString = SDKSupportPlugin.performStringSubstitution(pathString, null);
        ExtendedPath path = new ExtendedPath(pathString, isCopy, copyPath, isDir);
        path.setOpen(toOpen == null ? false : toOpen);
        path.setPublic(isPublic == null ? false : isPublic);
        path.setRenameTo(renameTo);
        return path;
    }

    private ExtendedPath(String fullPath, boolean isCopy, String copyPath, boolean isDir) {
        super(fullPath);
        this.setCopy(isCopy);
        this.setCopyPath(copyPath);
        this.isDir = isDir;
    }

    @Override
    public boolean isCopy() {
        return this.isCopy;
    }

    @Override
    public void setCopy(boolean isCopy) {
        this.isCopy = isCopy;
    }

    @Override
    public boolean isOverride() {
        return this.isOverride;
    }

    @Override
    public void setOverride(boolean isOverride) {
        this.isOverride = isOverride;
    }

    @Override
    public String copyPath() {
        return this.copyPath;
    }

    @Override
    public void setCopyPath(String copyPath) {
        if (copyPath != null && copyPath.isEmpty()) {
            copyPath = null;
        }
        this.copyPath = copyPath;
    }

    @Override
    public IExtendedPath[] matchedChildren(PathMatcher matcher, boolean recursive, IFileFilter filter) {
        IExtendedPath[] result;
        IExtendedPath[] iExtendedPathArray = result = recursive ? this.matchedRecursiveCache.get(matcher) : this.matchedPlainCache.get(matcher);
        if (result == null) {
            ArrayList<IExtendedPath> toProcess = new ArrayList<IExtendedPath>();
            File asFile = this.toFile();
            if (!asFile.isFile() && asFile.exists()) {
                File[] files;
                block7: {
                    files = ExtendedPath.filterOutNulls(this.listFiles(matcher, recursive, filter));
                    try {
                        Arrays.sort(files, new LocalComparator());
                    }
                    catch (Exception e) {
                        if (silentMode) break block7;
                        SDKSupportPlugin.log(String.format(Messages.ExtendedPath_exception_sort, e.getMessage()));
                    }
                }
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    toProcess.add(ExtendedPath.fromOSString(f.getAbsolutePath(), f.isDirectory()));
                    ++n2;
                }
            }
            result = toProcess.toArray(new IExtendedPath[0]);
            if (recursive) {
                this.matchedRecursiveCache.put(matcher, result);
            } else {
                this.matchedPlainCache.put(matcher, result);
            }
        }
        return result;
    }

    private static File[] filterOutNulls(File[] src) {
        if (src == null || src.length == 0) {
            return EMPTY_FILES;
        }
        ArrayList<File> lst = new ArrayList<File>();
        File[] fileArray = src;
        int n = src.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f == null || !f.exists() || !f.canRead() || f.isDirectory() && f.listFiles() == null) {
                SDKSupportPlugin.log(String.valueOf(Messages.ExtendedPath_removed) + f);
            } else {
                lst.add(f);
            }
            ++n2;
        }
        return lst.toArray(new File[lst.size()]);
    }

    private File[] listFiles(final PathMatcher matcher, final boolean recursive, final IFileFilter filter) {
        return this.toFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (matcher == null) {
                    return true;
                }
                boolean additional = filter == null ? true : filter.accept(file);
                java.nio.file.Path p = Paths.get(file.getAbsolutePath(), new String[0]);
                return file.isDirectory() && recursive && this.acceptChildren(file) || (matcher.matches(p.getFileName()) || matcher.matches(p)) && additional;
            }

            private boolean acceptChildren(File dir) {
                File[] files = dir.listFiles();
                if (files != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        if (this.accept(f)) {
                            return true;
                        }
                        ++n2;
                    }
                } else if (!silentMode) {
                    SDKSupportPlugin.log(String.format(Messages.ExtendedPath_list_is_null, dir.getAbsolutePath()));
                }
                return false;
            }
        });
    }

    @Override
    public String renameTo() {
        return this.renameTo;
    }

    @Override
    public void setRenameTo(String renameTo) {
        this.renameTo = renameTo;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Override
    public boolean toOpen() {
        return this.toOpen;
    }

    @Override
    public void setOpen(boolean toOpen) {
        this.toOpen = toOpen;
    }

    public String toString() {
        return "[" + this.toOSString() + (this.isCopy ? " COPY" : "") + (this.isPublic() ? " PUB" : "") + (this.toOpen() ? " OPEN" : "") + (this.renameTo() != null ? " REN:" + this.renameTo : "") + (this.copyPath() != null ? " COPY_PATH: " + this.copyPath() : "") + "]";
    }

    public static void setSilentMode(boolean mode) {
        silentMode = mode;
    }

    public static boolean getSilentMode() {
        return silentMode;
    }

    @Override
    public boolean isDirectory() {
        return this.isDir;
    }

    private static class LocalComparator
    implements Comparator<File> {
        private LocalComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.isDirectory() ^ o2.isDirectory() ? (o1.isDirectory() ? -1 : 1) : o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
        }
    }
}

