/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal.hook;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKHook;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SDKHookHandler {
    public static final SDKHookHandler INSTANCE = new SDKHookHandler();
    private static Map<ISDK, ISDKHook> sdkHooks = new HashMap<ISDK, ISDKHook>();

    public IStatus checkExecutePreconditions(ISDK sdk, int mode, Map<String, Object> context) {
        ISDKHook sdkHook = sdkHooks.get(sdk);
        return sdkHook == null ? Status.OK_STATUS : sdkHook.checkPreconditions(mode + 256, sdk, context);
    }

    public void execute(ISDK sdk, int mode, boolean after, Object cfg, String path) {
        ISDKHook sdkHook = sdkHooks.get(sdk);
        if (sdkHook == null) {
            return;
        }
        int state = mode >= 0 && mode <= 4 ? mode : 0 + mode;
        mode += after ? 512 : 256;
        try {
            sdkHook.stateChange(mode, sdk, cfg, path);
        }
        catch (Throwable e) {
            SDKSupportPlugin.error(NLS.bind((String)Messages.SDKHookHandler_error_hook_executing, (Object[])new String[]{sdkHook.getClass().getName(), after ? "AFTER" : "BEFORE", ISDKHook.STATES[state]}), e);
        }
    }

    public IStatus checkExecutePostconditions(ISDK sdk, int mode, Map<String, Object> context) {
        ISDKHook sdkHook = sdkHooks.get(sdk);
        return sdkHook == null ? Status.OK_STATUS : sdkHook.checkPostconditions(mode + 512, sdk, context);
    }

    public void registerSDKHook(ISDK sdk, ISDKHook sdkHook) {
        if (sdkHook == null) {
            return;
        }
        sdkHooks.put(sdk, sdkHook);
    }
}

