/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.model.AffectType;
import com.freescale.s32ds.cross.core.model.ContextStyle;
import com.freescale.s32ds.cross.core.model.DefaultWizardValueProvider;
import com.freescale.s32ds.cross.core.model.IDataInitilyzer;
import com.freescale.s32ds.cross.core.model.IEditorFactory;
import com.freescale.s32ds.cross.core.model.IParameterHandler;
import com.freescale.s32ds.cross.core.model.ITemplateVariableProvider;
import com.freescale.s32ds.cross.core.model.IWizardValueProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class ModelUtil {
    private static final char[] hexChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F'};

    public static String parseString(String s) {
        if (s == null || s.trim().length() == 0) {
            return "";
        }
        return s;
    }

    public static String parseString(String attributeName, String defaultValue, IConfigurationElement ce) {
        String value;
        if (ce != null && (value = ce.getAttribute(attributeName)) != null) {
            return value;
        }
        return defaultValue;
    }

    public static boolean parseBoolean(String s) {
        return ModelUtil.parseBoolean(s, false);
    }

    public static boolean parseBoolean(String s, boolean defaultValue) {
        if (s == null || s.isEmpty()) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static int parseInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            Activator.logWarning("Illegal int value " + s + "!");
            return 0;
        }
    }

    public static long parseLong(String s) {
        return ModelUtil.parseLong(s, 10);
    }

    public static long parseLong(String s, int radix) {
        if (s == null || s.trim().length() == 0) {
            return -1L;
        }
        String old = s;
        int n = s.length() - 1;
        int koef = 1;
        String us = s.toUpperCase();
        switch (us.charAt(n)) {
            case 'G': {
                koef *= 1024;
                radix = 10;
            }
            case 'M': {
                koef *= 1024;
                radix = 10;
            }
            case 'K': {
                koef *= 1024;
                radix = 10;
                s = s.substring(0, n);
            }
        }
        if (us.startsWith("0X")) {
            s = s.substring(2);
            radix = 16;
        } else if (us.startsWith("X")) {
            s = s.substring(1);
            radix = 16;
        }
        if (radix != 16) {
            char[] cArray = hexChars;
            int n2 = hexChars.length;
            int n3 = 0;
            while (n3 < n2) {
                char c = cArray[n3];
                if (us.indexOf(c) >= 0) {
                    radix = 16;
                    break;
                }
                ++n3;
            }
        }
        try {
            if (s.contains(".") || s.contains(",")) {
                return Math.round(Double.parseDouble(s.replace(',', '.'))) * (long)koef;
            }
            long l = Long.parseLong(s, radix) * (long)koef;
            return l;
        }
        catch (NumberFormatException e) {
            Activator.log(e, "Bad memory size: " + old + " -> " + s);
            return -1L;
        }
    }

    public static String convertToString(Object v) {
        if (v == null) {
            return "";
        }
        if (v instanceof Long) {
            return Long.toString((Long)v, 16);
        }
        return v.toString();
    }

    public static String toHexString(long n) {
        char[] c = Long.toHexString(n).toCharArray();
        char[] res = new char[c.length + c.length / 4];
        int l1 = c.length - 1;
        int l2 = res.length - 1;
        int i = 0;
        int j = 0;
        while (i < c.length) {
            res[l2 - j++] = c[l1 - i];
            if (i % 4 == 3) {
                res[l2 - j++] = 32;
            }
            ++i;
        }
        return new String(res).trim();
    }

    public static AffectType parseAffectType(String attributeValue) {
        if (attributeValue == null) {
            return AffectType.ALL;
        }
        try {
            return AffectType.valueOf(attributeValue);
        }
        catch (Exception exception) {
            Activator.logWarning("Unsupported affectType " + attributeValue);
            return AffectType.ALL;
        }
    }

    public static ContextStyle parseContextStyle(String attributeValue) {
        if (attributeValue == null) {
            return ContextStyle.DEFAULT;
        }
        try {
            return ContextStyle.valueOf(attributeValue);
        }
        catch (Exception exception) {
            Activator.logWarning("Unsupported context style " + attributeValue);
            return ContextStyle.DEFAULT;
        }
    }

    public static IParameterHandler parseParameterHandler(IConfigurationElement ce) {
        IParameterHandler h = (IParameterHandler)ModelUtil.createExecutableExtension("handler", ce, false);
        return h != null ? h : null;
    }

    public static IEditorFactory parseEditorFactory(IConfigurationElement ce) {
        return (IEditorFactory)ModelUtil.createExecutableExtension("editorFactory", ce, false);
    }

    public static IDataInitilyzer parseDataInitialyzer(IConfigurationElement ce) {
        return (IDataInitilyzer)ModelUtil.createExecutableExtension("initialyzer", ce, false);
    }

    public static ITemplateVariableProvider parseTemplateVariableProvider(IConfigurationElement ce) {
        return (ITemplateVariableProvider)ModelUtil.createExecutableExtension("variableProvider", ce, false);
    }

    public static IWizardValueProvider parseWizardValueProvider(IConfigurationElement ce) {
        IWizardValueProvider vp = (IWizardValueProvider)ModelUtil.createExecutableExtension("valueProvider", ce, false);
        return vp != null ? vp : new DefaultWizardValueProvider();
    }

    protected static Object createExecutableExtension(String classAttribute, IConfigurationElement ce, boolean printWarning) {
        if (ce.getAttribute(classAttribute) != null) {
            try {
                return ce.createExecutableExtension(classAttribute);
            }
            catch (CoreException e) {
                Activator.logWarning(String.valueOf(classAttribute) + " initialization problem " + ce.getName() + " " + e.getMessage());
            }
        }
        return null;
    }
}

