/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.data;

import com.freescale.s32ds.cross.core.model.EditorType;
import com.freescale.s32ds.cross.core.model.ModelUtil;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.data.DataFactory;
import com.freescale.s32ds.cross.core.model.data.DataSet;
import com.freescale.s32ds.cross.core.model.data.SimpleData;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public abstract class ConfigurationData {
    private final String tag;
    private final String id;
    private final String name;
    private final String description;
    private final ConfigurationData parent;
    private final ModelRegistry registry;

    ConfigurationData(IConfigurationElement ce, ConfigurationData parent, ModelRegistry registry) {
        this(ce.getName(), ce.getAttribute("id"), ce.getAttribute("name"), ce.getAttribute("description"), parent, registry);
    }

    ConfigurationData(String tag, ConfigurationData parent, ModelRegistry registry) {
        this(tag, tag, tag, "", parent, registry);
    }

    public ConfigurationData(String tag, String id, String name, String description, ConfigurationData parent, ModelRegistry registry) {
        if (id == null) {
            Collection<ConfigurationData> registeredTypes = registry.getDatas(tag);
            int index = registeredTypes.size() + 1;
            id = String.valueOf(tag) + "#" + index;
        } else if (name == null) {
            name = id;
        }
        if (description == null) {
            description = "";
        }
        this.tag = tag;
        this.id = id;
        this.name = name;
        this.description = description;
        this.parent = parent;
        this.registry = registry;
        registry.registerData(this);
    }

    public String getTag() {
        return this.tag;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ConfigurationData getParent() {
        return this.parent;
    }

    public ModelRegistry getRegistry() {
        return this.registry;
    }

    public ConfigurationData getParent(String tag) {
        ConfigurationData p = this.getParent();
        while (p != null) {
            if (p.getTag().equals(tag)) {
                return p;
            }
            p = p.getParent();
        }
        return null;
    }

    public boolean isProcessor() {
        return "processor".equals(this.tag);
    }

    public boolean isCore() {
        return "core".equals(this.tag);
    }

    public boolean isCoreType() {
        return "coreType".equals(this.tag);
    }

    public boolean isCoreKind() {
        return "coreKind".equals(this.tag);
    }

    public boolean isFamily() {
        return "family".equals(this.tag);
    }

    public boolean isTemplate() {
        return "template".equals(this.tag);
    }

    public boolean isSet() {
        return this.tag.endsWith("Set");
    }

    public List<Object> getValueRange() {
        return this.collectValues(this.getElements(), false);
    }

    public List<Object> getValueRange(String tag) {
        return this.collectValues(this.getElements(tag), false);
    }

    public List<String> getDisplayValueRange() {
        return this.collectValues(this.getElements(), true);
    }

    public List<String> getDisplayValueRange(String tag) {
        return this.collectValues(this.getElements(tag), true);
    }

    public abstract String getValue(String var1);

    public abstract String getDisplayValue(String var1);

    public String getStringValue(String tag) {
        return this.getValue(tag);
    }

    public long getLongValue(String tag) {
        return ModelUtil.parseLong(this.getValue(tag), 16);
    }

    public int getIntValue(String tag) {
        return ModelUtil.parseInteger(this.getValue(tag));
    }

    public int getIntValue(String tag, int def) {
        try {
            return Integer.parseInt(this.getValue(tag));
        }
        catch (Exception exception) {
            return def;
        }
    }

    public Boolean getBooleanValue(String tag) {
        return ModelUtil.parseBoolean(this.getValue(tag));
    }

    public abstract ConfigurationData getElement(String var1);

    public abstract List<ConfigurationData> getElements();

    public abstract List<ConfigurationData> getElements(String var1);

    public abstract List<ConfigurationData> getElements(String var1, boolean var2);

    protected abstract List<ConfigurationData> getElements(String var1, boolean var2, boolean var3);

    protected String getBaseInfo() {
        return String.valueOf(this.tag) + "-" + this.getId();
    }

    public void init() {
    }

    private List<?> collectValues(List<ConfigurationData> datas, boolean display) {
        ArrayList<String> result = new ArrayList<String>();
        for (ConfigurationData data : datas) {
            if (display) {
                result.add(data.getName());
                continue;
            }
            if (data instanceof SimpleData) {
                result.add(((SimpleData)data).getValue());
                continue;
            }
            result.add(data.getId());
        }
        return result;
    }

    public static List<ConfigurationData> getDataRange(String tag, Map<String, ConfigurationData> from) {
        String elementsTag = ParameterType.findElementTag(tag);
        String setTag = ParameterType.findSetTag(tag);
        List<ConfigurationData> ds = ConfigurationData.getDataRange(elementsTag, from.get(elementsTag), false);
        return !ds.isEmpty() ? ds : ConfigurationData.getDataRange(elementsTag, from.get(setTag), true);
    }

    public static List<ConfigurationData> getDataRange(String tag, Collection<ConfigurationData> from) {
        boolean isSetTag = tag.endsWith("Set");
        for (ConfigurationData data : from) {
            List<ConfigurationData> ds = ConfigurationData.getDataRange(tag, data, isSetTag);
            if (ds.isEmpty()) continue;
            return ds;
        }
        return Collections.EMPTY_LIST;
    }

    public static List<ConfigurationData> getDataRange(String tag, ConfigurationData from) {
        return ConfigurationData.getDataRange(tag, from, tag.endsWith("Set"));
    }

    private static List<ConfigurationData> getDataRange(String tag, ConfigurationData from, boolean isSetTag) {
        if (from == null) {
            return Collections.EMPTY_LIST;
        }
        if (from.isSet()) {
            String compareTag;
            DataSet ds = (DataSet)from;
            String string = compareTag = isSetTag ? ds.getTag() : ds.getElementTag();
            if (compareTag.equals(tag)) {
                return ds.getElements();
            }
        } else if (from.getTag().equals(tag)) {
            return Arrays.asList(from);
        }
        return Collections.EMPTY_LIST;
    }

    public static ConfigurationData getData(String tag, ConfigurationData parent) {
        return ConfigurationData.getData(tag, null, parent);
    }

    public static ConfigurationData getData(String tag, Object value, ConfigurationData parent) {
        return ConfigurationData.getData(tag, value, parent, false);
    }

    public static ConfigurationData getData(String tag, Object value, ConfigurationData parent, boolean createParameter) {
        if (parent == null) {
            return null;
        }
        ParameterType parameterType = parent.getRegistry().getParameterType(tag);
        if (parameterType == null) {
            if (createParameter) {
                parameterType = ParameterType.createUndeclaredType(tag);
            } else {
                return null;
            }
        }
        if (EditorType.SELECTION == parameterType.getEditorType() || EditorType.MULTI_SELECTION == parameterType.getEditorType()) {
            ArrayList<ConfigurationData> datas = new ArrayList<ConfigurationData>(parent.getRegistry().getDatas(parameterType.getTag()));
            if (value != null) {
                for (ConfigurationData data : datas) {
                    if (!data.getId().equals(value)) continue;
                    return data;
                }
            }
            return datas.size() > 0 ? (ConfigurationData)datas.get(0) : null;
        }
        return DataFactory.createSimpleData(parameterType, value, parent);
    }
}

