/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.registry;

import com.freescale.s32ds.cross.core.model.ContextStyle;
import com.freescale.s32ds.cross.core.model.ContextType;
import com.freescale.s32ds.cross.core.model.DefaultParameterHandler;
import com.freescale.s32ds.cross.core.model.IParameterHandler;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.registry.ContextPart;

public class ContextDefinition {
    private final String id;
    private final String name;
    private final ContextType type;
    private final ContextStyle style;
    private String description;
    private ContextPart defaultPart = new ContextPart();
    private ContextPart terminationPart = new ContextPart();

    public ContextDefinition(ContextType type) {
        this(type, type.name(), type.name(), new DefaultParameterHandler(), ContextStyle.DEFAULT);
    }

    public ContextDefinition(ContextType type, String id, String name, IParameterHandler parameterHandler, ContextStyle style) {
        this.type = type;
        this.id = id != null ? id : type.name();
        this.name = name != null ? name : type.name();
        this.style = style;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ContextType getType() {
        return this.type;
    }

    public ContextPart getDefaultPart() {
        return this.defaultPart;
    }

    public void setDefaultPart(ContextPart part) {
        if (part != null) {
            this.defaultPart = part;
        }
    }

    public ContextPart getTerminationPart() {
        return this.terminationPart;
    }

    public void setTerminationPart(ContextPart part) {
        if (part != null) {
            this.terminationPart = part;
        }
    }

    public Parameter getParameter(String tag) {
        Parameter ref = this.defaultPart.getParameter(tag);
        return ref != null ? ref : this.terminationPart.getParameter(tag);
    }

    public IParameterHandler getParameterHandler(String tag) {
        IParameterHandler h = this.defaultPart.getParameterHandler(tag);
        if (h == null) {
            h = this.terminationPart.getParameterHandler(tag);
        }
        return h;
    }

    public ContextStyle getStyle() {
        return this.style;
    }
}

