/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.checker.core;

import com.nxp.s32ds.ext.ide.checker.IResourceChecker;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;

public class CheckerService
implements IResourceChangeListener {
    private static final String BUNDLE_ID = "com.nxp.s32ds.ext.ide.checker";
    private static final String CHECKER_EXTENSION_POINT_NAME = "com.nxp.s32ds.ext.ide.checker.s32dsCheckers";
    private Map<String, IResourceChecker> checkers;

    public void init() {
        WorkspaceJob chekerInitJob = new WorkspaceJob("Initialize Resources Checkers"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IStatus status = CheckerService.this.loadCheckerExtentions();
                if (!status.isOK()) {
                    return status;
                }
                CheckerService.this.runChekersOnOpenProjects(monitor);
                return status;
            }
        };
        chekerInitJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                CheckerService.this.addResourceChangeListener();
            }
        });
        chekerInitJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        chekerInitJob.schedule();
    }

    private void runChekersOnOpenProjects(IProgressMonitor monitor) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                this.check(project, monitor);
            }
            monitor.worked(1);
            ++n2;
        }
    }

    protected void check(final IProject project, IProgressMonitor monitor) {
        String subTaskName = NLS.bind((String)"Checking {0} ", (Object)project.getName());
        WorkspaceJob chekerJob = new WorkspaceJob(subTaskName){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                MultiStatus ms = new MultiStatus(CheckerService.BUNDLE_ID, 0, new String(), null);
                for (Map.Entry checkerEntries : CheckerService.this.checkers.entrySet()) {
                    try {
                        IStatus checkStatus = ((IResourceChecker)checkerEntries.getValue()).check((IResource)project, monitor);
                        if (checkStatus == null) continue;
                        ms.add(checkStatus);
                    }
                    catch (Exception e) {
                        Status status = new Status(4, CheckerService.BUNDLE_ID, e.getMessage(), (Throwable)e);
                        ms.add((IStatus)status);
                    }
                }
                return ms;
            }
        };
        chekerJob.setRule((ISchedulingRule)project);
        chekerJob.schedule();
    }

    private IStatus loadCheckerExtentions() {
        MultiStatus mt = new MultiStatus(BUNDLE_ID, 0, new String(), null);
        this.checkers = new HashMap<String, IResourceChecker>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(CHECKER_EXTENSION_POINT_NAME);
        if (point == null) {
            String msg = NLS.bind((String)"Could not find extension point id: {0}", (Object)CHECKER_EXTENSION_POINT_NAME);
            mt.add((IStatus)new Status(4, BUNDLE_ID, msg));
            return mt;
        }
        IExtension[] extensions = point.getExtensions();
        if (extensions == null || extensions.length == 0) {
            return Status.OK_STATUS;
        }
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if (el.getName().equals("checker")) {
                    try {
                        String id = el.getAttribute("id");
                        IResourceChecker checker = (IResourceChecker)el.createExecutableExtension("class");
                        this.checkers.put(id, checker);
                    }
                    catch (CoreException coreException) {
                        String msg = NLS.bind((String)"Could not create executable extension id: {0}", (Object)el.getAttribute("id"));
                        mt.add((IStatus)new Status(4, BUNDLE_ID, msg));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return mt;
    }

    private void addResourceChangeListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 8);
    }

    public Map<String, IResourceChecker> getCheckers() {
        return this.checkers;
    }

    public void clearRunner() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getDelta() == null) {
            return;
        }
        try {
            event.getDelta().accept(delta -> {
                if (delta.getResource() instanceof IProject && this.hasChangesToCheck(delta)) {
                    IProject project = (IProject)delta.getResource();
                    if (project.isOpen()) {
                        this.check(project, (IProgressMonitor)new NullProgressMonitor());
                    }
                    return false;
                }
                return true;
            });
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
    }

    private boolean hasChangesToCheck(IResourceDelta delta) {
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childrenDelta = iResourceDeltaArray[n2];
            if (this.hasChangesToCheck(childrenDelta)) {
                return true;
            }
            ++n2;
        }
        if (delta.getFlags() == 131072) {
            return false;
        }
        return delta.getFlags() != 0;
    }
}

