/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license.cli;

import com.nxp.s32ds.ext.rcp.license.cli.Settings;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.Activate;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.ActivateUI;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.ICommand;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.InstallActivation;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.InstallService;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.List;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.Refresh;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.ReturnFeature;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.ReturnLicense;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.TestOffline;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.UninstallService;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.Verify;
import com.nxp.s32ds.ext.rcp.license.cll.CLL;
import java.util.HashMap;
import java.util.Map;

public class CLI {
    private static final int EXIT_CODE_ERROR = 1;
    private static final String IDENT_STR = "\t";
    private final Map<String, ICommand> commands = new HashMap<String, ICommand>();

    public static void main(String[] args) {
        new CLI().execute(args);
    }

    public void execute(String[] args) {
        try {
            CLL cll = new CLL();
            Settings settings = new Settings();
            this.reg(new InstallService(settings, cll));
            this.reg(new Activate(settings, cll));
            this.reg(new ActivateUI(settings, cll));
            this.reg(new Verify(settings, cll));
            this.reg(new InstallActivation(cll, settings));
            this.reg(new UninstallService(settings, cll));
            this.reg(new ReturnLicense(settings, cll));
            this.reg(new ReturnFeature(settings, cll));
            this.reg(new List(settings, cll));
            this.reg(new Refresh(settings, cll));
            this.reg(new TestOffline(settings, cll));
            settings.parseArgs(args);
            String commandName = settings.getCommandName();
            if (!this.commands.containsKey(commandName)) {
                throw new IllegalArgumentException("missing command: " + commandName);
            }
            ICommand cmd = this.commands.get(commandName);
            if (!cmd.canExecute()) {
                System.err.println(cmd.getProblemDescription());
                System.err.println(cmd.getOneLineDesc());
                System.exit(1);
            }
            System.exit(cmd.execute());
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() == null) {
                System.err.println("Illegal Argument");
            } else {
                System.err.println("Illegal Argument: " + e.getMessage());
            }
            System.out.println(this.help());
            System.exit(1);
        }
    }

    private String help() {
        StringBuffer sb = new StringBuffer();
        sb.append("CLI format:\n");
        sb.append("java -jar cll.jar <cmd> <params>\n\n");
        sb.append("<cmd> are:\n");
        for (Map.Entry<String, ICommand> p : this.commands.entrySet()) {
            ICommand cmd = p.getValue();
            sb.append("'" + p.getKey() + "': " + cmd.getOneLineDesc() + "\n");
            for (Map.Entry<String, String> pp : cmd.getOneLineParamsDesc().entrySet()) {
                sb.append("\t-" + pp.getKey() + "\t " + pp.getValue() + "\n");
            }
        }
        return sb.toString();
    }

    private void reg(ICommand cmd) {
        this.commands.put(cmd.getName(), cmd);
    }
}

