/*
 * main.c   FTM example
 * 2016 Jun 03 Osvaldo Romero - Initial version
 * 2016 Oct 31 SM: Clocks adjusted for 160 MHz SPLL
 *
 */

#include "S32K144.h"          /* include peripheral declarations S32K144 */
#include "clocks_and_modes.h"
#include "FTM.h"

void PORT_init (void) {
  PCC->PCCn[PCC_PORTD_INDEX ]|=PCC_PCCn_CGC_MASK;   /* Enable clock for PORTD */
  PCC->PCCn[PCC_PORTE_INDEX ]|=PCC_PCCn_CGC_MASK;   /* Enable clock for PORTE */
  PORTE->PCR[8]|=PORT_PCR_MUX(2);           		/* Port E8: MUX = ALT2, FTM0CH6 */
  PORTD->PCR[15]|=PORT_PCR_MUX(2);           		/* Port D15: MUX = ALT2, FTM0CH0 */
  PORTD->PCR[16]|=PORT_PCR_MUX(2);           		/* Port D16: MUX = ALT2, FTM0CH1 */
}

void WDOG_disable (void) {
  WDOG->CNT=0xD928C520;     /* Unlock watchdog */
  WDOG->TOVAL=0x0000FFFF;   /* Maximum timeout value */
  WDOG->CS = 0x00002100;    /* Disable watchdog */
}

int main(void) {
  WDOG_disable();        /* Disable WDOG*/
  SOSC_init_8MHz();      /* Initialize system oscillator for 8 MHz xtal */
  SPLL_init_160MHz();    /* Initialize SPLL to 160 MHz with 8 MHz SOSC */
  NormalRUNmode_80MHz(); /* Init clocks: 80 MHz SPLL & core, 40 MHz bus, 20 MHz flash */
  FTM0_init();           /* Init FTM0 using 8 MHz SOSCDIV1_CLK */
  FTM0_CH0_OC_init();    /* Init FTM0 CH0, red LED */
  FTM0_CH1_PWM_init();   /* Init FTM0 CH1, green LED */
  FTM0_CH6_IC_init();    /* Init FTM0 CH6, j2-8 */
  PORT_init();           /* Configure ports */
  start_FTM0_counter();  /* Start FTM0 counter */
  for(;;) {
   	FTM0_CH0_output_compare();/* If output compare match: */
                              /* Pin toggles (automatically by hardware) */
                              /* Clear flag 8 */
                              /* Reload timer */
   	FTM0_CH6_input_capture(); /* If input captured: clear flag, read timer */
  }
}
