package com.freescale.s32ds.cross.sdk.s32k116_1_8_7.pexconf;


import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;

import com.freescale.s32ds.cross.sdk.ISDK;

public class PExConfigk116 extends APExConfig {

	public PExConfigk116() {
	}

	@Override
	public void stateChange(int mode, ISDK sdk, Object cfg, String path) {

        if (mode == MODE_AFTER_ATTACH_ALL) {
			IProject curProject = getProject(cfg);
			if (curProject != null) {
				new PExConfigk116Adjuster(curProject).adjustPExConfiguration();
				ManagedBuildManager.saveBuildInfo(curProject, true);
			}
		}
	}

	private IProject getProject(Object cfg) {
		IProject curProject = null;
		if (cfg instanceof ICConfigurationDescription) {
			ICConfigurationDescription cfgd = (ICConfigurationDescription) cfg;
			return cfgd.getProjectDescription().getProject();
		} else if (cfg instanceof IConfiguration) {
			return (IProject) ((IConfiguration) cfg).getManagedProject().getOwner();
		} else {
			Activator.log(new IllegalArgumentException("Fail to invoke PExConfigk116 Hook")); //$NON-NLS-1$
		}
		return curProject;
	}
}