
	.data  :   AT(__DATA_ROM)
	{
   	    . = ALIGN(4);
   		 __DATA_RAM = .;
  		  __data_start__ = .;      /* create a global symbol at data start */
	    *(.data*)
         KEEP(*(.jcr*))
        . = ALIGN(4);
		__DATA_END = .;
		__data_end__ = .;        /* define a global symbol at data end */
	} > GRAM
	
	__DATA_END = __DATA_ROM + (__data_end__ - __data_start__);
	
	.bss ALIGN(16) :
    {
        __bss_start__ = .;
        *(.bss*)       /* Zero-filled run time allocate data memory */
        *(COMMON)        
        __bss_end__ = .;
    } > GRAM


	/* stack and heap shall be located in the same memory region */
	.heap ALIGN(8): 
    {
        __end__ = .;
        PROVIDE(_end = .);
    	PROVIDE(end = .);
    	. += HEAP_SIZE;
    } > GRAM

    .stack  ALIGN(8):
    {
         _stack_s = .;
        . += STACK_SIZE;
        __StackTop = .;
    } > GRAM 
    
    PROVIDE(__stack = __StackTop);
    
	/* Labels required by EWL */
    __START_BSS = __bss_start__;
    __END_BSS = __bss_end__;
    __SP_INIT = __StackTop;  
}

