/*========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************
*/

/* Specify the memory areas */
MEMORY
{
    FLASH_CONFIG        : ORIGIN = 0x18f9c000, 		        LENGTH = 16K
    M_INTERRUPTS        : ORIGIN = 0x19000000,              LENGTH = 0x400
    FLASH_CODE          : ORIGIN = 0x19000400,              LENGTH = 0x7C00
    CODE_A5             : ORIGIN = 0x19008000,              LENGTH = 0x80000
    GRAM                : ORIGIN = 0x3F000000 + 0x100,      LENGTH = 1M - 0x100 - 256K
    IOP_RAM             : ORIGIN = 0x3E400000,              LENGTH = 32K
}

/* Define output sections */
SECTIONS
{
  // Defaults
  HEAP_SIZE  = isdefined(__heap_size__)  ? __heap_size__  : 0x0400;
  STACK_SIZE = isdefined(__stack_size__) ? __stack_size__ : 0x0400;
  M_VECTOR_RAM_SIZE = isdefined(__ram_vector_table__) ? 0x0400 : 0x0;

  .flash_config :
  {
    . = ALIGN(4);
    "*(.flashConfig)"    /* Flash Configuration Field (FCF) */
    . = ALIGN(4);
  } > FLASH_CONFIG
  
  .interrupts :
  {
    __VECTOR_TABLE = .;
    . = ALIGN(4);
    "*(.isr_vector)"     /* Startup code */   
    . = ALIGN(4);
  } > M_INTERRUPTS

  /* The program code and other data goes into internal flash */
  .text :
  {
    . = ALIGN(4);
    "*(.text)"               /* .text sections (code) */
    "*(.text*)"              /* .text* sections (code) */
    "*(.intercall)" 
    "*(.interfunc)" 
    "*(.syscall)" 
    "*(.rodata)"             /* .rodata sections (constants, strings, etc.) */
    "*(.rodata*)"            /* .rodata* sections (constants, strings, etc.) */
    "*(.glue_7)"             /* glue arm to thumb code */
    "*(.glue_7t)"            /* glue thumb to arm code */
    "*(.eh_frame)"
    "*(.init)"
    "*(.fini)"
    . = ALIGN(4);
  } > FLASH_CODE

  .ARM.extab :
  {
    "*(.ARM.extab* .gnu.linkonce.armextab.*)"
  } > .

  .ARM :
  {
    __exidx_start = .;
    "*(.ARM.exidx*)"
    __exidx_end = .;
  } > .

 .ctors :
  {
    __CTOR_LIST__ = .;
    "*(.ctors.*)"
    "*(.ctors)"
    __CTOR_END__ = .;
  } > .

  .dtors :
  {
    __DTOR_LIST__ = .;
    "*(.dtors.*)"
    "*(.dtors)"
    __DTOR_END__ = .;
  } > .

  .preinit_array :
  {
    __preinit_array_start = .;
    "*(.preinit_array*)"
    __preinit_array_end = .;
  } > .

  .init_array :
  {
    __init_array_start = .;
    "*(.init_array.*)"
    "*(.init_array*)"
    __init_array_end = .;
  } > .

  .fini_array :
  {
    __fini_array_start = .;
    "*(.fini_array.*)"
    "*(.fini_array*)"
    __fini_array_end = .;
  } > .

 