   
	.data 	          ALIGN(4)             : 
	{
	    __DATA_RAM = .;
        __DATA_ROM = .;
	    *(.data*)
         KEEP(*(.jcr*))
        . = ALIGN(4);
		__DATA_END = .;
	} > GRAM
	
	.bss ALIGN(16) :
    {
         __bss_start__ = .;
        *(.bss*)       /* Zero-filled run time allocate data memory */
        *(COMMON)        
        __bss_end__ = .;
    }  > GRAM
    
	.CodeRelocateRam  ALIGN(0)  : 
	{
	    CODE_RELOCATE_SRAM = .;
	    CODE_RELOCATE_ROM = .;
	    *(.CodeRelocateRam*)
		CODE_RELOCATE_ROM_END = .;
	} > GRAM

	/* stack and heap shall be located in the same memory region */
	.heap    ALIGN(8): 
    {
        __end__ = .;
        _end = .;
    	PROVIDE(end = .);
    	. += HEAP_SIZE;
    }  > GRAM   

    .stack   ALIGN(8)   :
    {
         _stack_s = .;
        . += STACK_SIZE;
        __StackTop = .;
    } > GRAM
    
    PROVIDE(__stack = __StackTop);
    
	/* Labels required by EWL */
    __START_BSS = __bss_start__;
    __END_BSS = __bss_end__;
    __SP_INIT = __StackTop;  	  
}