/*
** ###################################################################
**     Processor:           S32V_M4
**     Compiler:            GreenHills ARM Compiler
**
**     Abstract:
**         Linker file for the GreenHills ARM Compiler
**
**     Copyright (c) 2016 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
** ###################################################################
*/

/* Specify the memory areas */
MEMORY {
    FLASH_CONFIG        : ORIGIN = 0x10000000 + 0x200,                     LENGTH = 0x140
    FLASH_APP_HDR       : ORIGIN = 0x10000000 + 0x1000,                    LENGTH = 0x40
    FLASH_BOOT_DATA     : ORIGIN = 0x10000000 + 0x1000 + 0x40,             LENGTH = 0xC
    FLASH_DCD           : ORIGIN = 0x10000000 + 0x1000 + 0x40 + 0xC + 0x4, LENGTH = 0x30 
    VECTOR_TABLE        : ORIGIN = 0x10000000 + 0x1400,                    LENGTH = 0x800
    FLASH               : ORIGIN = 0x10000000 + 0x1400 + 0x800,            LENGTH = 0x4000000 - 0x800 - 0x1400
    SRAM                : ORIGIN = 0x3E800000,                             LENGTH = 0x3FF000 /* EDMA Descriptor Area (0x1000 bytes) from 0x3EBFF000*/
    TCM_DATA            : ORIGIN = 0x3E000000,                             LENGTH = 0x4000
}

/* Define output sections */
SECTIONS
{
  // Defaults
  HEAP_SIZE  = isdefined(__heap_size__)  ? __heap_size__  : 0x0400;
  STACK_SIZE = isdefined(__stack_size__) ? __stack_size__ : 0x0400;
  M_VECTOR_RAM_SIZE = isdefined(__ram_vector_table__) ? 0x0400 : 0x0;

  /* The startup code goes first into internal flash */
  .interrupts :
  {
    __VECTOR_TABLE = .;
    . = ALIGN(4);
    "*(.intvec)"     /* Startup code */   
    . = ALIGN(4);
  } > VECTOR_TABLE

 
    .QSPIFlashConfig :
    {
    "*(.QSPIFlashConfig)"    /* Flash Configuration Field (FCF) */
    } > FLASH_CONFIG
    
    .flash_app_hdr :
    {
    "*(.flash_app_hdr)"    /* Flash Configuration Field (FCF) */
    } > FLASH_APP_HDR
    
    .flash_boot_data :
    {
    "*(.flash_boot_data)"    /* Flash Configuration Field (FCF) */
    } > FLASH_BOOT_DATA
    
    .flash_dcd :
    {
   "*(.flash_dcd)"    /* Flash Configuration Field (FCF) */
    } > FLASH_DCD

  /* The program code and other data goes into internal flash */
  .text :
  {
    . = ALIGN(4);
    "*(.text)"               /* .text sections (code) */
    "*(.text*)"              /* .text* sections (code) */
    "*(.intercall)" 
    "*(.interfunc)" 
    "*(.syscall)" 
    "*(.rodata)"             /* .rodata sections (constants, strings, etc.) */
    "*(.rodata*)"            /* .rodata* sections (constants, strings, etc.) */
    "*(.glue_7)"             /* glue arm to thumb code */
    "*(.glue_7t)"            /* glue thumb to arm code */
    "*(.eh_frame)"
    "*(.init)"
    "*(.fini)"
    . = ALIGN(4);
  } > FLASH

  .ARM.extab :
  {
    "*(.ARM.extab* .gnu.linkonce.armextab.*)"
  } > FLASH

  .ARM :
  {
    __exidx_start = .;
    "*(.ARM.exidx*)"
    __exidx_end = .;
  } > FLASH

 .ctors :
  {
    __CTOR_LIST__ = .;
    "*(.ctors.*)"
    "*(.ctors)"
    __CTOR_END__ = .;
  } > FLASH

  .dtors :
  {
    __DTOR_LIST__ = .;
    "*(.dtors.*)"
    "*(.dtors)"
    __DTOR_END__ = .;
  } > FLASH

  .preinit_array :
  {
    __preinit_array_start = .;
    "*(.preinit_array*)"
    __preinit_array_end = .;
  } > FLASH

  .init_array :
  {
    __init_array_start = .;
    "*(.init_array.*)"
    "*(.init_array*)"
    __init_array_end = .;
  } > FLASH

  .fini_array :
  {
    __fini_array_start = .;
    "*(.fini_array.*)"
    "*(.fini_array*)"
    __fini_array_end = .;
  } > FLASH

  __etext = .;    /* define a global symbol at end of code */
  __DATA_ROM = .; /* Symbol is used by startup for data initialization */

  .interrupts_ram :
  {
    . = ALIGN(4);
    __VECTOR_RAM__ = .;
    __interrupts_ram_start__ = .; /* Create a global symbol at data start */
    *(.m_interrupts_ram)     /* This is a user defined section */
    . += M_VECTOR_RAM_SIZE;
    . = ALIGN(4);
    __interrupts_ram_end__ = .; /* Define a global symbol at data end */
  } > SRAM


  __VECTOR_RAM = isdefined(__ram_vector_table__) ? __VECTOR_RAM__ : addr(VECTOR_TABLE);
  __RAM_VECTOR_TABLE_SIZE_BYTES = isdefined(__ram_vector_table__) ? (__interrupts_ram_end__ - __interrupts_ram_start__) : 0x0;

  .data : AT(__DATA_ROM)
  {
    . = ALIGN(4);
    __DATA_RAM = .;
    __data_start__ = .;      /* create a global symbol at data start */
    "*(.data)"               /* .data sections */
    "*(.data*)"              /* .data* sections */
    "*(.jcr*)"
    . = ALIGN(4);
    __data_end__ = .;        /* define a global symbol at data end */
  } > SRAM

  __DATA_END = __DATA_ROM + (__data_end__ - __data_start__);

  /* Uninitialized data section */
  .bss :
  {
    /* This is used by the startup in order to initialize the .bss section */
    . = ALIGN(4);
    __START_BSS = .;
    __bss_start__ = .;
    "*(.bss)"
    "*(.bss*)"
    "*(COMMON)"
    . = ALIGN(4);
    __bss_end__ = .;
    __END_BSS = .;
  } > SRAM

  .heap :
  {
    . = ALIGN(8);
    __end__ = .;
    PROVIDE(end = .);
    __HeapBase = .;
    . += HEAP_SIZE;
    __HeapLimit = .;
  } > TCM_DATA

  .stack :
  {
    . = ALIGN(8);
    . += STACK_SIZE;
  } > TCM_DATA

  /* Initializes stack on the end of block */
  __StackTop   = addr(TCM_DATA) + sizeof(TCM_DATA);
  __StackLimit = __StackTop - STACK_SIZE;
  PROVIDE(__stack = __StackTop);
  
  __SRAM_START_ADDRESS__ = addr(SRAM); 
  __RAM_SIZE__ = sizeof(SRAM);

  __TCM_DATA_START_ADDRESS__ = addr(TCM_DATA); 
  __TCM_DATA_SIZE__ = sizeof(TCM_DATA);


  .ARM.attributes :
  {
    *(.ARM.attributes)
  }

}

