/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.suppliers;

import com.nxp.s32ds.ext.cdt.suppliers.PersistentPreferences;
import com.nxp.s32ds.ext.cdt.suppliers.ProjectStorage;
import com.nxp.s32ds.ext.ide.utils.PreferencesUtils;
import java.io.File;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;

public class EnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    public static final String OPTION_PREFIX = "com.freescale.s32ds.cross.gnu.option";
    public static final String OPTION_TOOLCHAIN_NAME = "com.freescale.s32ds.cross.gnu.option.toolchain.name";

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (PathEnvironmentVariable.isVar(variableName)) {
            return PathEnvironmentVariable.create(configuration);
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        PathEnvironmentVariable path = PathEnvironmentVariable.create(configuration);
        if (path != null) {
            return new IBuildEnvironmentVariable[]{path};
        }
        return new IBuildEnvironmentVariable[0];
    }

    private static class PathEnvironmentVariable
    implements IBuildEnvironmentVariable {
        public static String name = "PATH";
        private File path;

        private PathEnvironmentVariable(File path) {
            this.path = path;
        }

        public static PathEnvironmentVariable create(IConfiguration configuration) {
            IToolChain toolchain = configuration.getToolChain();
            IProject project = (IProject)configuration.getManagedProject().getOwner();
            String path = PersistentPreferences.getBuildToolsPath(project);
            IOption option = toolchain.getOptionBySuperClassId(EnvironmentVariableSupplier.OPTION_TOOLCHAIN_NAME);
            String toolchainName = (String)option.getValue();
            String toolchainPath = null;
            boolean isPathPerProject = ProjectStorage.isToolchainPathPerProject(configuration);
            if (isPathPerProject) {
                toolchainPath = ProjectStorage.getToolchainPath(configuration);
                PersistentPreferences.putToolchainPath(toolchainName, toolchainPath, project);
                ProjectStorage.putToolchainPathPerProject(configuration, false);
            }
            toolchainPath = PersistentPreferences.getToolchainPath(toolchainName, project);
            if (path.isEmpty()) {
                path = toolchainPath;
            } else if (!toolchainPath.isEmpty()) {
                path = String.valueOf(path) + PreferencesUtils.getPathSeparator();
                path = String.valueOf(path) + toolchainPath;
            }
            if (!path.isEmpty()) {
                File sysroot;
                File bin;
                if (path.indexOf("${") >= 0) {
                    path = PathEnvironmentVariable.resolveMacros(path, configuration);
                }
                if ((bin = new File(sysroot = new File(path), "bin")).isDirectory()) {
                    sysroot = bin;
                }
                return new PathEnvironmentVariable(sysroot);
            }
            return null;
        }

        private static String resolveMacros(String str, IConfiguration configuration) {
            String result = str;
            try {
                result = ManagedBuildManager.getBuildMacroProvider().resolveValue(str, "", " ", 3, (Object)configuration);
            }
            catch (CdtVariableException e) {
                System.out.println("resolveMacros " + e.getMessage());
            }
            return result;
        }

        public static boolean isVar(String name) {
            return Platform.getOS().equals("win32") ? name.equalsIgnoreCase(PathEnvironmentVariable.name) : name.equals(PathEnvironmentVariable.name);
        }

        public String getDelimiter() {
            return Platform.getOS().equals("win32") ? ";" : ":";
        }

        public String getName() {
            return name;
        }

        public int getOperation() {
            return 3;
        }

        public String getValue() {
            return this.path.getAbsolutePath();
        }
    }
}

