/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.gnu.arm.importer;

import com.freescale.s32ds.cross.gnu.arm.Activator;
import com.freescale.s32ds.cross.gnu.arm.Messages;
import com.freescale.s32ds.cross.gnu.arm.importer.ImportAbstract;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;

public class ImportKDS
extends ImportAbstract {
    static final Map<String, String> SUPP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("SKEAZ128xxx4_flash.ld", "SKEAZ128M4");
            this.put("SKEAZ64xxx4_flash.ld", "SKEAZ64M4");
            this.put("SKEAZN16xxx2_flash.ld", "SKEAZN16M2");
            this.put("SKEAZN32xxx2_flash.ld", "SKEAZN32M2");
            this.put("SKEAZN64xxx2_flash.ld", "SKEAZN64M2");
            this.put("SKEAZN8xxx4_flash.ld", "SKEAZN8M4");
        }
    };
    private static final String PATH_0 = "/.project";
    private static final String PATH_1 = "/.settings/com.processorexpert.core.ide.newprojectwizard.prefs";
    private static final String PATH_2 = "/.settings/com.freescale.processorexpert.derivative.prefs";
    private static final String TC_ID = "ilg.gnuarmeclipse.managedbuild.cross.toolchain.elf.debug";
    private static final String DEV_ID = "<DeviceID>";
    private static final String[] TOOLS = new String[]{"tool.cpp.compiler.", "tool.c.compiler.", "tool.assembler."};
    private static final String[] TAB = new String[]{"option.optimization.level", "option.optimization.messagelength", "option.optimization.signedchar", "option.optimization.functionsections", "option.optimization.datasections", "option.debugging.level"};
    private static final String SRC0 = "</configuration>";
    private static final String SRC1 = "\n\t\t\t<sourceEntries>";
    private static final String SRC2 = "\n\t\t\t\t<entry flags=\"VALUE_WORKSPACE_PATH|RESOLVED\" kind=\"sourcePath\" name=\"";
    private static final String SRC3 = "\"/>";
    private static final String SRC4 = "\n\t\t\t</sourceEntries>\t\t\n</configuration>";
    private static final String[] SOURCES = new String[]{"Project_Settings/Debugger", "Project_Settings/Linker_Files", "Project_Settings/Startup_Code", "Includes", "include", "Generated_Code", "Sources", "Static_Code/System", "PDD", "Static_Code/IO_Map"};
    private static final String[][] FOR_ARM = new String[][]{{Messages.ImportKDS_26, Messages.ImportKDS_27}, {Messages.ImportKDS_28, Messages.ImportKDS_29}, {Messages.ImportKDS_30, Messages.ImportKDS_31}, {Messages.ImportKDS_32, Messages.ImportKDS_33}, {Messages.ImportKDS_34, "com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.mcpu"}, {"ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.", "com.freescale.s32ds.cross.gnu.arm.cortexm.option.target."}, {"ilg.gnuarmeclipse.managedbuild.cross.option.assembler.usepreprocessor", "com.freescale.s32ds.cross.gnu.tool.assembler.usepreprocessor"}, {"ilg.gnuarmeclipse.managedbuild.cross.option.createlisting", "com.freescale.s32ds.cross.gnu.option.createlisting"}, {"ilg.gnuarmeclipse.managedbuild.cross.option.printsize", "com.freescale.s32ds.cross.gnu.option.printsize"}, {"ilg.gnuarmeclipse.managedbuild.cross.tool.createlisting", "com.freescale.s32ds.cross.gnu.tool.createlisting"}, {"ilg.gnuarmeclipse.managedbuild.cross.tool.printsize", "com.freescale.s32ds.cross.gnu.tool.printsize"}, {"ilg.gnuarmeclipse.managedbuild.cross.option.", "com.freescale.s32ds.cross.gnu.arm.cortexm.option."}, {"org.eclipse.cdt.build.core.buildArtefactType", "com.freescale.s32ds.cross.gnu.arm.cortexm.buildArtefact"}, {"ilg.gnuarmeclipse.managedbuild.cross.toolchain.elf.", "com.freescale.s32ds.cross.gnu.arm.cortexm.toolChain."}, {"ilg.gnuarmeclipse.managedbuild.cross.target.elf", "com.freescale.s32ds.cross.gnu.arm.cortexm.exe"}, {"ilg.gnuarmeclipse.managedbuild.cross.tool.", "com.freescale.s32ds.cross.gnu.arm.cortexm.tool."}, {"ilg.gnuarmeclipse.managedbuild.cross.", "com.freescale.s32ds.cross.gnu."}, {" superClass=\"com.freescale.s32ds.cross.gnu.arm.cortexm.option.c.compiler.include.paths\"", " superClass=\"gnu.c.compiler.option.include.paths\""}, {" superClass=\"com.freescale.s32ds.cross.gnu.arm.cortexm.option.cpp.compiler.include.paths\"", " superClass=\"gnu.cpp.compiler.option.include.paths\""}, {"name=\"Cross ARM ", "unusedChildren=\""}, {"value=\"-nanolibc\"", "value=\"-specs=nosys.specs\""}, {"com.freescale.s32ds.cross.gnu.option.optimization.level", "com.freescale.s32ds.cross.gnu.tool.assembler.option.optimization.level"}, {"com.freescale.s32ds.cross.gnu.option.debugging.level", "com.freescale.s32ds.cross.gnu.tool.assembler.option.debugging.level"}, {"com.freescale.s32ds.cross.gnu.tool.cpp.linker.option.paths", "gnu.cpp.link.option.paths"}, {"com.freescale.s32ds.cross.gnu.tool.c.linker.option.paths", "gnu.c.link.option.paths"}, {"-specs=nano.specs", ""}, {"-specs=nosys.specs", ""}};

    public String convert(String s, String toolchainString, boolean isPE, String path) {
        int i = 0;
        while (i < FOR_ARM.length) {
            s = s.replace(FOR_ARM[i][0], FOR_ARM[i][1]);
            ++i;
        }
        s = this.addSources(s, path);
        if (toolchainString != null) {
            s = s.replace(" superClass=\"com.freescale.s32ds.cross.gnu.arm.cortexm.toolChain.debug\"", toolchainString);
        }
        s = ImportKDS.insertLD(s);
        String[] stringArray = TAB;
        int n = TAB.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            s = ImportKDS.moveOpt(s, TOOLS, op);
            ++n2;
        }
        s = this.normalize(s, "newlib_nano_noio", true, isPE);
        return s;
    }

    public String fits(String loc, boolean strict, boolean pe) {
        int n;
        block22: {
            File project = new File(String.valueOf(loc) + PATH_0);
            if (!project.exists()) {
                return Messages.ImportCW_no_prj;
            }
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileReader fr = new FileReader(project);){
                    if (fr.read() != -1) break block22;
                    return Messages.ImportCW_prj_empty;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Activator.log(e);
                return String.valueOf(Messages.ImportCW_error_reading) + e.getMessage();
            }
        }
        if (!new File(String.valueOf(loc) + PATH_1).exists() && !new File(String.valueOf(loc) + PATH_2).exists()) {
            return Messages.ImportKDS_not_kds;
        }
        File ff = new File(String.valueOf(loc) + "/.cproject");
        String s = this.read(ff);
        if (s == null) {
            return "Failed opening " + ff.toString();
        }
        if (!s.contains(TC_ID)) {
            return "The project does not contain known toolchain.";
        }
        if (!pe && new File(String.valueOf(loc) + "/ProcessorExpert.pe").exists()) {
            return Messages.ImportKDS_PE_not_allowed;
        }
        ff = new File(String.valueOf(loc) + "/ProjectInfo.xml");
        String src = this.read(ff);
        if (src != null && (n = src.indexOf(DEV_ID)) > 0 && (n = (src = src.substring(n + DEV_ID.length())).indexOf(60)) > 0) {
            src = src.substring(0, n);
            for (String sup : SUPP.keySet()) {
                if (!sup.startsWith(src)) continue;
                return null;
            }
        }
        if (!s.contains("id=\"ilg.gnuarmeclipse.managedbuild.cross.toolchain.elf")) {
            return Messages.ImportKDS_not_kds;
        }
        if (strict) {
            for (String sup : SUPP.keySet()) {
                if (!s.contains(sup)) continue;
                return null;
            }
            return "The project does not contain supported processor type.";
        }
        return null;
    }

    public boolean postProcess(String path) {
        String root = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocationURI().getPath()) + path;
        return ImportKDS.delete(new File(String.valueOf(root) + "/Debug"));
    }

    private String addSources(String s, String path) {
        StringBuilder sb = new StringBuilder();
        sb.append(SRC1);
        String[] stringArray = SOURCES;
        int n = SOURCES.length;
        int n2 = 0;
        while (n2 < n) {
            String x = stringArray[n2];
            if (new File(String.valueOf(path) + '/' + x).isDirectory()) {
                sb.append(SRC2).append(x).append(SRC3);
            }
            ++n2;
        }
        return s.replace(SRC0, sb.append(SRC4).toString());
    }

    @Override
    public Map<String, String> getProcessors() {
        return SUPP;
    }
}

