/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.exports;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import com.freescale.s32ds.cross.wizard.pi.ProjectInfoPathProcessor;
import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.freescale.s32ds.cross.wizard.pi.exports.DefaultOptionProvider;
import com.freescale.s32ds.cross.wizard.pi.exports.IPIExporterDataProvider;
import com.freescale.s32ds.cross.wizard.pi.exports.ProjectInfoExportSettings;
import com.freescale.s32ds.cross.wizard.pi.jaxb.BuildOptionsType;
import com.freescale.s32ds.cross.wizard.pi.jaxb.CoreDescriptionType;
import com.freescale.s32ds.cross.wizard.pi.jaxb.CoresType;
import com.freescale.s32ds.cross.wizard.pi.jaxb.Export;
import com.freescale.s32ds.cross.wizard.pi.jaxb.FILEStype;
import com.freescale.s32ds.cross.wizard.pi.jaxb.OPTIONStype;
import com.freescale.s32ds.cross.wizard.pi.jaxb.ObjectFactory;
import com.freescale.s32ds.cross.wizard.pi.jaxb.OptionListType;
import com.freescale.s32ds.cross.wizard.pi.jaxb.PATHStype;
import com.freescale.s32ds.cross.wizard.pi.jaxb.PROCESSORtype;
import com.freescale.s32ds.cross.wizard.pi.jaxb.PathListType;
import com.freescale.s32ds.cross.wizard.pi.jaxb.PathNameListType;
import com.freescale.s32ds.cross.wizard.pi.jaxb.PathNameType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class PIWriter {
    private final ProjectInfoExportSettings settings;
    private String linkerCommadFile;
    private final IPIExporterDataProvider dataProvider;

    public PIWriter(ProjectInfoExportSettings settings) {
        this(settings, new DefaultOptionProvider(settings));
    }

    public PIWriter(ProjectInfoExportSettings settings, IPIExporterDataProvider dataProvider) {
        this.settings = settings;
        this.dataProvider = dataProvider;
    }

    public Export createExport() throws CoreException {
        ObjectFactory of = new ObjectFactory();
        Export result = of.createExport();
        this.settings.getProject();
        result.setOPTIONS(this.createOptions(of));
        result.setPROCESSOR(PIWriter.createProccessor(of, this.settings));
        result.setPATHS(this.createPaths(of, this.settings.getProject()));
        result.setFILES(this.createFiles(of));
        return result;
    }

    private OPTIONStype createOptions(ObjectFactory of) {
        OPTIONStype result = of.createOPTIONStype();
        BuildOptionsType buildOptions = of.createBuildOptionsType();
        OptionListType asmOpts = of.createOptionListType();
        OptionListType ccOpts = of.createOptionListType();
        OptionListType linkerOpts = of.createOptionListType();
        result.setBuildOptions(buildOptions);
        buildOptions.setCCoptList(ccOpts);
        buildOptions.setLinkerOptList(linkerOpts);
        buildOptions.setASMoptList(asmOpts);
        ccOpts.getOption().addAll(this.dataProvider.getCCOpts());
        asmOpts.getOption().addAll(this.dataProvider.getAsmOpts());
        linkerOpts.getOption().addAll(this.dataProvider.getLinkerOptions());
        this.linkerCommadFile = this.dataProvider.getLinkerCommandFile();
        if (this.dataProvider.mergeOptions()) {
            this.joinOptions(result);
        }
        return result;
    }

    private void joinOptions(OPTIONStype result) {
        List<String> optionArm = result.getBuildOptions().getASMoptList().getOption();
        List<String> optionCCopt = result.getBuildOptions().getCCoptList().getOption();
        List<String> optionLinker = result.getBuildOptions().getLinkerOptList().getOption();
        String armOption = optionArm.stream().collect(Collectors.joining(" "));
        String cCompilerOption = optionCCopt.stream().collect(Collectors.joining(" "));
        String cLinkerOption = optionLinker.stream().collect(Collectors.joining(" "));
        optionArm.clear();
        optionCCopt.clear();
        optionLinker.clear();
        optionArm.add(armOption);
        optionCCopt.add(cCompilerOption);
        optionLinker.add(cLinkerOption);
    }

    private static PROCESSORtype createProccessor(ObjectFactory of, ProjectInfoExportSettings settings) {
        PROCESSORtype result = of.createPROCESSORtype();
        result.setDeviceID(settings.getPIDeviceID());
        result.setCoreNum(Byte.valueOf("1"));
        CoresType cores = of.createCoresType();
        result.setCores(cores);
        CoreDescriptionType coreDef = of.createCoreDescriptionType();
        coreDef.setCoreSet(settings.getPICoreSet());
        cores.getCore().add(coreDef);
        result.setFLASHsize("0K");
        result.setSRAMsize("0K");
        return result;
    }

    private PATHStype createPaths(ObjectFactory of, IProject project) throws CoreException {
        PATHStype result = of.createPATHStype();
        if (this.settings.getAbsolutePaths().booleanValue()) {
            result.setProjectInfoPath(this.settings.getOutputFile().toAbsolutePath().toString());
        }
        this.setLinkerFile(result);
        PathListType includes = of.createPathListType();
        includes.getPath().addAll(this.settings.getAbsolutePaths() != false ? this.makeAbsolute(this.dataProvider.getIncludePaths()) : this.dataProvider.getIncludePaths());
        result.setIncludePaths(includes);
        PathListType sources = of.createPathListType();
        sources.getPath().addAll(this.settings.getAbsolutePaths() != false ? this.makeAbsolute(this.dataProvider.getSourceCodePaths()) : this.dataProvider.getSourceCodePaths());
        result.setSourceCodePaths(sources);
        PathListType libs = of.createPathListType();
        for (String str : this.createPathSet("a")) {
            libs.getPath().add(str);
        }
        result.setLibPaths(libs);
        return result;
    }

    private List<String> makeAbsolute(List<String> paths) throws CoreException {
        ArrayList<String> result = new ArrayList<String>();
        for (String path : paths) {
            IResource resource = this.settings.getProject().findMember(path);
            if (resource != null && resource.isVirtual()) {
                path = this.resolveFromSDK(resource, this.settings);
            }
            result.add(ProjectInfoPathProcessor.makeAbsOrRel(path, this.settings.getAbsolutePaths(), this.settings.getConfiguration()));
        }
        return result;
    }

    private String resolveFromSDK(IResource resource, ProjectInfoExportSettings settings) {
        for (ISDK sdk : SDKAttach.getAttached((IProject)resource.getProject())) {
            if (!resource.getName().equals(sdk.getName())) continue;
            return SDKSupportPlugin.getEclipsePath((ISDK)sdk).toOSString();
        }
        return null;
    }

    private void setLinkerFile(PATHStype result) throws CoreException {
        if (this.linkerCommadFile != null) {
            result.setLinkerCommandFile(ProjectInfoPathProcessor.makeAbsOrRel(this.linkerCommadFile, this.settings.getAbsolutePaths(), this.settings.getConfiguration()));
        } else {
            for (String path : this.dataProvider.getFiles("ld,icf")) {
                if (result.getLinkerCommandFile() != null) {
                    S32DSWizardPiPlugin.logWarning("LinkerCommandFile double set. Was: " + result.getLinkerCommandFile() + " new: " + path);
                }
                result.setLinkerCommandFile(ProjectInfoPathProcessor.makeAbsOrRel(path, this.settings.getAbsolutePaths(), this.settings.getConfiguration()));
            }
        }
    }

    private Set<String> createPathSet(String exts) {
        return this.dataProvider.getFiles(exts).stream().map(s -> {
            File file = new File((String)s);
            return file.isDirectory() ? file.toString() : file.getParent();
        }).collect(Collectors.toSet());
    }

    private static PathNameListType addPathTypes(ObjectFactory of, List<String> strs) {
        PathNameListType files = of.createPathNameListType();
        for (String str : strs) {
            PathNameType pathType = of.createPathNameType();
            pathType.setValue(str);
            files.getPathName().add(pathType);
        }
        return files;
    }

    private FILEStype createFiles(ObjectFactory of) {
        FILEStype result = of.createFILEStype();
        result.setGeneratedCs(PIWriter.addPathTypes(of, this.dataProvider.getFiles("c, cpp, spt")));
        result.setGeneratedHs(PIWriter.addPathTypes(of, this.dataProvider.getFiles("h")));
        result.setGeneratedASMs(PIWriter.addPathTypes(of, this.dataProvider.getFiles("s")));
        result.setLibraries(PIWriter.addPathTypes(of, this.dataProvider.getFiles("a")));
        return result;
    }
}

