/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.exports.toolchains;

import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.freescale.s32ds.cross.wizard.pi.exports.ProjectInfoExportSettings;
import com.freescale.s32ds.cross.wizard.pi.exports.toolchains.IToolChainExporter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class FreescaleS32DSToolChainExporter
implements IToolChainExporter {
    private static final String TOOL_C_LINKER = "tool.c.linker";
    private static final String TOOL_ASSEMBLER = "tool.assembler";
    private static final String TOOL_C_COMPILER = "tool.c.compiler";
    private static final String MERGED_LD_NAME = "merged.ld";
    private static final String EMPTY = "";

    @Override
    public boolean isLinker(ITool tool) {
        return tool.getId().contains(TOOL_C_LINKER);
    }

    @Override
    public boolean isAssembler(ITool tool) {
        return tool.getId().contains(TOOL_ASSEMBLER);
    }

    @Override
    public boolean isCCompiler(ITool tool) {
        return tool.getId().contains(TOOL_C_COMPILER);
    }

    @Override
    public boolean isFits(IToolChain toolchain) {
        return toolchain.getId().startsWith("com.freescale.s32ds.cross") || toolchain.getId().startsWith("com.nxp.s32ds.cle.arm.mbs");
    }

    @Override
    public List<String> processOptions(ITool tool, List<String> options, ProjectInfoExportSettings settings) {
        List<String> processerOptions = this.isLinker(tool) ? this.mergeLinkerFiles(options, settings.getConfiguration()) : options;
        return IToolChainExporter.super.processOptions(tool, processerOptions, settings);
    }

    private List<String> mergeLinkerFiles(List<String> options, ICConfigurationDescription configuration) {
        ArrayList<String> linkerFilesOpts = new ArrayList<String>();
        for (String oString : options) {
            linkerFilesOpts.addAll(this.getLinkerCommandFileOpts(oString));
        }
        if (linkerFilesOpts.size() < 2) {
            return options;
        }
        String oneFilePath = Paths.get(this.extractFilePathFromOpt((String)linkerFilesOpts.get(0), configuration), new String[0]).getParent().toString();
        Path outFile = Paths.get(String.valueOf(oneFilePath) + File.separator + this.generateName(Paths.get(oneFilePath, new String[0]).getParent().toString(), MERGED_LD_NAME), new String[0]);
        if (outFile.toFile().exists()) {
            outFile.toFile().delete();
        }
        String result = "-T \"" + outFile + "\" " + options;
        for (String opt : linkerFilesOpts) {
            try {
                List<String> lines = Files.readAllLines(Paths.get(this.extractFilePathFromOpt(opt, configuration), new String[0]));
                Files.write(outFile, lines, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                result = result.replace(opt, EMPTY);
            }
            catch (IOException e) {
                S32DSWizardPiPlugin.log(e);
            }
        }
        return Arrays.asList(result);
    }

    private List<String> getLinkerCommandFileOpts(String options) {
        Matcher matcher = Pattern.compile("(-T \"[^ ]*\"|-T [^ ]*\")").matcher(options);
        ArrayList<String> linkerFilesOpts = new ArrayList<String>();
        while (matcher.find()) {
            int i = 1;
            while (i <= matcher.groupCount()) {
                linkerFilesOpts.add(matcher.group(i));
                ++i;
            }
        }
        return linkerFilesOpts;
    }

    private String extractFilePathFromOpt(String opt, ICConfigurationDescription configuration) {
        IStringVariableManager varMng = VariablesPlugin.getDefault().getStringVariableManager();
        String fileString = opt.substring("-T ".length()).replace("\"", EMPTY);
        try {
            fileString = CCorePlugin.getDefault().getCdtVariableManager().resolveValue(fileString, EMPTY, EMPTY, configuration);
            return varMng.performStringSubstitution(fileString, false);
        }
        catch (CoreException e) {
            S32DSWizardPiPlugin.log(e);
            return fileString;
        }
    }

    private String generateName(String path, String base) {
        return new File(String.valueOf(path) + File.separator + base).exists() ? this.generateName(path, String.valueOf('_') + base) : base;
    }

    @Override
    public String getLinkerCommandFile(List<String> options, ProjectInfoExportSettings settings) {
        ArrayList<String> opts = new ArrayList<String>();
        for (String option : options) {
            opts.addAll(this.getLinkerCommandFileOpts(option));
        }
        if (opts.size() == 1) {
            return this.extractFilePathFromOpt((String)opts.get(0), settings.getConfiguration());
        }
        return null;
    }
}

