/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.imports;

import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.freescale.s32ds.cross.wizard.pi.imports.IOptionProcessor;
import com.freescale.s32ds.cross.wizard.pi.imports.OptionDelta;
import com.freescale.s32ds.cross.wizard.pi.imports.PIReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;

public class DefaultOptionProcessor
implements IOptionProcessor {
    private static final String EMPTY = "";
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";
    private static final String SLASH = "/";
    private static final String BSLSH = "\\";
    private static final String I = "-I";
    private static final String D = "-D";
    private static final String T = "-T";
    private static final String L = "-L";
    private static final String TOOL_C_LINKER = "tool.c.linker";
    private static final String TOOL_ASSEMBLER = "tool.assembler";
    private static final String TOOL_C_COMPILER = "tool.c.compiler";
    private static final String GNU_C_COMPILER_OPTION_INCLUDE_PATHS = "gnu.c.compiler.option.include.paths";
    private static final String GNU_BOTH_ASM_OPTION_INCLUDE_PATHS = "gnu.both.asm.option.include.paths";
    private static final String GNU_C_COMPILER_OPTION_PREPROCESSOR_DEF_SYMBOLS = "gnu.c.compiler.option.preprocessor.def.symbols";
    private static final String ASSEMBLER_OPTION_DEFS = "com.freescale.s32ds.cross.gnu.tool.assembler.option.defs";
    private static final String GNU_C_LINK_OPTION_PATHS = "gnu.c.link.option.paths";
    private static final String CROSS_GNU_TOOL_C_LINKER = "com.freescale.s32ds.cross.gnu.tool.c.linker.option.scriptfile";
    private static final String TOOLCHAIN_SYSROOT_OPTION_NAME = "Sysroot";
    private static final Pattern SCRIPT_FILE_PATTERN = Pattern.compile("-T ?\"([^ ]*)\"|-T ?([^ ]*)");
    private static final Pattern LIBRARY_SEARCH_PATH_PATTERN = Pattern.compile("-L ?\"([^ ]*)\"|-L ?([^ ]*)");
    private static final Pattern SYSROOT_PATTERN = Pattern.compile("--sysroot=\"[^\"]+\"|--sysroot=[^ ]+");
    private static final Pattern INCLUDE_PATTERN = Pattern.compile("-I ?\"([^\"]+)\"|-I ?([^ ]+)");
    private static final Pattern DEFINED_SYMBOLS_PATTERN = Pattern.compile("(^|\\s)-D\\S*");

    private List<OptionDelta> setToolOption(IConfiguration cfg, ITool iTool, IOption option, PIReader piReader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        if (this.isAssembler(iTool.getId())) {
            result.addAll(this.setASMOption(cfg, iTool, option, piReader));
        } else if (this.isCCompiler(iTool.getId())) {
            result.addAll(this.setCompalerOption(cfg, iTool, option, piReader));
        } else if (this.isLinker(iTool.getId())) {
            result.addAll(this.setLinkerOption(cfg, iTool, option, piReader));
        }
        return result;
    }

    private List<OptionDelta> setToolChainOption(IConfiguration cfg, IOption iOption, PIReader piReader) {
        String findSysRootOptionValue;
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        if (TOOLCHAIN_SYSROOT_OPTION_NAME.equals(iOption.getName()) && (findSysRootOptionValue = this.findSysRootOptionValue(piReader)) != null) {
            result.add(this.setSystemRoot(cfg, (IHoldsOptions)cfg.getToolChain(), iOption, findSysRootOptionValue));
        }
        result.addAll(this.setEnumerationOption(cfg, (IHoldsOptions)cfg.getToolChain(), iOption, piReader.getOptionsASM()));
        result.addAll(this.setEnumerationOption(cfg, (IHoldsOptions)cfg.getToolChain(), iOption, piReader.getOptionsLinker()));
        result.addAll(this.setEnumerationOption(cfg, (IHoldsOptions)cfg.getToolChain(), iOption, piReader.getOptionsCC()));
        return result;
    }

    private String findSysRootOptionValue(PIReader piReader) {
        if (!EMPTY.equals(this.findValue(SYSROOT_PATTERN, piReader.getOptionsASM()))) {
            return this.findValue(SYSROOT_PATTERN, piReader.getOptionsASM());
        }
        if (!EMPTY.equals(this.findValue(SYSROOT_PATTERN, piReader.getOptionsCC()))) {
            return this.findValue(SYSROOT_PATTERN, piReader.getOptionsCC());
        }
        if (!EMPTY.equals(this.findValue(SYSROOT_PATTERN, piReader.getOptionsLinker()))) {
            return this.findValue(SYSROOT_PATTERN, piReader.getOptionsLinker());
        }
        return null;
    }

    private List<OptionDelta> setASMOption(IConfiguration cfg, ITool iTool, IOption option, PIReader reader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        List<String> optionsASM = reader.getOptionsASM();
        if (option.getId().startsWith(GNU_BOTH_ASM_OPTION_INCLUDE_PATHS)) {
            result.addAll(this.setIncludePaths(cfg, iTool, option, optionsASM, reader));
        } else if (option.getId().startsWith(ASSEMBLER_OPTION_DEFS)) {
            result.addAll(this.setDefinedSymbolsPattern(cfg, iTool, option, optionsASM));
        } else if (option.getApplicableValues().length > 0) {
            result.addAll(this.setEnumerationOption(cfg, (IHoldsOptions)iTool, option, optionsASM));
        } else if (TOOLCHAIN_SYSROOT_OPTION_NAME.equals(option.getName())) {
            result.add(this.setSystemRoot(cfg, (IHoldsOptions)iTool, option, this.findValue(SYSROOT_PATTERN, optionsASM)));
        }
        return result;
    }

    private List<OptionDelta> setLinkerOption(IConfiguration cfg, ITool iTool, IOption option, PIReader reader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        List<String> optionsCLinker = reader.getOptionsLinker();
        if (option.getApplicableValues().length > 0) {
            result.addAll(this.setEnumerationOption(cfg, (IHoldsOptions)iTool, option, optionsCLinker));
        } else if (TOOLCHAIN_SYSROOT_OPTION_NAME.equals(option.getName())) {
            result.add(this.setSystemRoot(cfg, (IHoldsOptions)iTool, option, this.findValue(SYSROOT_PATTERN, optionsCLinker)));
        } else if (option.getId().startsWith(CROSS_GNU_TOOL_C_LINKER)) {
            result.addAll(this.setScriptFile(cfg, iTool, option, reader));
        } else if (option.getId().startsWith(GNU_C_LINK_OPTION_PATHS)) {
            result.addAll(this.setLibrarySearchPath(cfg, iTool, option, reader));
        }
        return result;
    }

    private List<OptionDelta> setCompalerOption(IConfiguration cfg, ITool iTool, IOption option, PIReader reader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        List<String> optionsCompiler = reader.getOptionsCC();
        if (option.getId().startsWith(GNU_C_COMPILER_OPTION_INCLUDE_PATHS)) {
            result.addAll(this.setIncludePaths(cfg, iTool, option, optionsCompiler, reader));
        } else if (option.getId().startsWith(GNU_C_COMPILER_OPTION_PREPROCESSOR_DEF_SYMBOLS)) {
            result.addAll(this.setPreprocessorDef(cfg, iTool, option, optionsCompiler));
        } else if (option.getApplicableValues().length > 0) {
            result.addAll(this.setEnumerationOption(cfg, (IHoldsOptions)iTool, option, optionsCompiler));
        } else if (TOOLCHAIN_SYSROOT_OPTION_NAME.equals(option.getName())) {
            result.add(this.setSystemRoot(cfg, (IHoldsOptions)iTool, option, this.findValue(SYSROOT_PATTERN, optionsCompiler)));
        }
        return result;
    }

    private boolean isLinker(String toolId) {
        return toolId.contains(TOOL_C_LINKER);
    }

    private boolean isAssembler(String toolId) {
        return toolId.contains(TOOL_ASSEMBLER);
    }

    private boolean isCCompiler(String toolId) {
        return toolId.contains(TOOL_C_COMPILER);
    }

    private List<OptionDelta> setPreprocessorDef(IConfiguration cfg, ITool iTool, IOption option, List<String> optionsCompiler) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String optional = this.findValue(DEFINED_SYMBOLS_PATTERN, optionsCompiler).trim();
        if (!optional.equals(EMPTY)) {
            result.add(this.setOption(DEFINED_SYMBOLS_PATTERN, cfg, iTool, option, optional, D));
        }
        return result;
    }

    private List<OptionDelta> setDefinedSymbolsPattern(IConfiguration cfg, ITool iTool, IOption option, List<String> optionsASM) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String optional = this.findValue(DEFINED_SYMBOLS_PATTERN, optionsASM).trim();
        if (!optional.equals(EMPTY)) {
            result.add(this.setOption(DEFINED_SYMBOLS_PATTERN, cfg, iTool, option, optional, D));
        }
        return result;
    }

    private List<OptionDelta> setScriptFile(IConfiguration cfg, ITool iTool, IOption option, PIReader reader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String optional = this.findValue(SCRIPT_FILE_PATTERN, reader.getOptionsLinker());
        if (!optional.equals(EMPTY)) {
            optional = this.replaceOldProjectLocationToNewInString(optional, cfg, reader);
            result.add(this.setOption(SCRIPT_FILE_PATTERN, cfg, iTool, option, optional, T));
        }
        return result;
    }

    private List<OptionDelta> setIncludePaths(IConfiguration cfg, ITool iTool, IOption option, List<String> optionValues, PIReader reader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String optional = this.findValue(INCLUDE_PATTERN, optionValues);
        if (!optional.equals(EMPTY)) {
            optional = this.replaceOldProjectLocationToNewInString(optional, cfg, reader);
            result.add(this.setOption(INCLUDE_PATTERN, cfg, iTool, option, optional, I));
        }
        return result;
    }

    private List<OptionDelta> setLibrarySearchPath(IConfiguration cfg, ITool iTool, IOption option, PIReader reader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        List<String> optionsCLinker = reader.getOptionsLinker();
        String optional = this.findValue(LIBRARY_SEARCH_PATH_PATTERN, optionsCLinker);
        if (!optional.equals(EMPTY)) {
            optional = this.replaceOldProjectLocationToNewInString(optional, cfg, reader);
            result.add(this.setOption(LIBRARY_SEARCH_PATH_PATTERN, cfg, iTool, option, optional, L));
        }
        return result;
    }

    protected List<OptionDelta> setEnumerationOption(IConfiguration cfg, IHoldsOptions holdsOptions, IOption iOption, List<String> values) {
        ArrayList<String> valuesToSet = new ArrayList<String>();
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String[] stringArray = iOption.getApplicableValues();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String optionValueFromGUI = stringArray[n2];
            try {
                String commandValue = iOption.getCommand(iOption.getEnumeratedId(optionValueFromGUI));
                for (String xmlValue : values) {
                    if (commandValue.isEmpty() || !xmlValue.contains(commandValue)) continue;
                    valuesToSet.add(optionValueFromGUI);
                }
                if (!valuesToSet.isEmpty()) {
                    String valueToSet = this.processCollisionValues(cfg, holdsOptions, valuesToSet);
                    String optionValueId = iOption.getEnumeratedId(valueToSet);
                    result.add(new OptionDelta(cfg, holdsOptions, iOption, optionValueId));
                }
            }
            catch (BuildException e) {
                S32DSWizardPiPlugin.log(e);
            }
            ++n2;
        }
        return result;
    }

    private String processCollisionValues(IConfiguration cfg, IHoldsOptions holdsOptions, List<String> valuesToSet) {
        String valueToSet = null;
        int length = -1;
        for (String string : valuesToSet) {
            if (string.length() <= length) continue;
            length = string.length();
            valueToSet = string;
        }
        return valueToSet;
    }

    private OptionDelta setSystemRoot(IConfiguration cfg, IHoldsOptions holdsOptions, IOption iOption, String value) {
        return new OptionDelta(cfg, holdsOptions, iOption, value);
    }

    protected OptionDelta setOption(Pattern pattern, IConfiguration cfg, ITool iTool, IOption option, String optional, String optionSymbol) {
        Matcher matcher = pattern.matcher(optional);
        HashSet<String> lines = new HashSet<String>();
        while (matcher.find()) {
            String targetOption = null;
            if (matcher.groupCount() > 1) {
                this.setPathsOptions(cfg, optionSymbol, matcher, lines);
            } else {
                targetOption = matcher.group(0).replace(optionSymbol, EMPTY);
            }
            if (targetOption == null) continue;
            lines.add(targetOption);
        }
        return new OptionDelta(cfg, (IHoldsOptions)iTool, option, lines.toArray(new String[0]));
    }

    private void setPathsOptions(IConfiguration cfg, String optionSymbol, Matcher matcher, Set<String> lines) {
        int i = 1;
        while (i <= matcher.groupCount()) {
            String group;
            if (I.equals(optionSymbol) | T.equals(optionSymbol) | L.equals(optionSymbol) && (group = matcher.group(i)) != null) {
                if (this.isContainsCDTVars(cfg, group) || Paths.get(group, new String[0]).isAbsolute()) {
                    lines.add(QUOTE + group + QUOTE);
                } else {
                    lines.add("\"${ProjDirPath}/" + this.removePrefix(group.replace(BSLSH, SLASH)) + QUOTE);
                }
            }
            ++i;
        }
    }

    private String removePrefix(String group) {
        while (group.startsWith("../") || group.startsWith("./")) {
            String string = group = group.startsWith("../") ? group.substring(3, group.length()) : group.substring(2, group.length());
        }
        return group;
    }

    private boolean isContainsCDTVars(IConfiguration cfg, String group) {
        try {
            return Arrays.stream(CCorePlugin.getDefault().getCdtVariableManager().getVariables(ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)cfg))).filter(p -> group.contains(p.getName())).findAny().isPresent();
        }
        catch (Exception e) {
            S32DSWizardPiPlugin.log(e, e.getMessage());
            return false;
        }
    }

    protected String findValue(Pattern pattern, List<String> values) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : values) {
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                stringBuilder.append(matcher.group(0)).append(SPACE);
            }
        }
        return stringBuilder.toString();
    }

    private String replaceOldProjectLocationToNewInString(String location, IConfiguration cfg, PIReader reader) {
        String oldStr = reader.getProjectInfoPath();
        oldStr = oldStr == null ? reader.getRootFolder() : Paths.get(oldStr, new String[0]).getParent().toString();
        oldStr = oldStr.replace('\\', '/');
        location = location.replace('\\', '/');
        String newStr = cfg.getOwner().getLocation().toString().replace('\\', '/');
        if (!oldStr.equals(newStr) && location.contains(oldStr)) {
            int n = location.indexOf(oldStr);
            location = String.valueOf(location.substring(0, n)) + newStr + location.substring(oldStr.length() + n);
        }
        return location;
    }

    @Override
    public List<OptionDelta> prepareChanges(IConfiguration cfg, PIReader piReader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        Arrays.stream(cfg.getToolChain().getOptions()).forEach(option -> result.addAll(this.setToolChainOption(cfg, (IOption)option, piReader)));
        Arrays.stream(cfg.getToolChain().getTools()).forEach(tool -> Arrays.stream(tool.getOptions()).forEach(option -> result.addAll(this.setToolOption(cfg, (ITool)tool, (IOption)option, piReader))));
        return result;
    }
}

