/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.imports;

import com.freescale.s32ds.cross.core.lingvo.Lingvo;
import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.freescale.s32ds.cross.wizard.pi.imports.IOptionProcessor;
import com.freescale.s32ds.cross.wizard.pi.imports.PIReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.templateengine.TemplateEngineUI;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ProjectInfoImportSettings {
    private static String PI_DEVICE = "pi.Device";
    private static String PI_CORESET = "pi.CoreSet";
    private static String ATTR_ID = "id";
    private static String ATTR_TC = "toolchain";
    private static String ATTR_CL = "class";
    private String projectName = "";
    private WritableValue<Object> piReaderWV;
    private PIReader piReader;
    private IProjectType selectedProjectType;
    private final Lingvo lingvo;
    private IOptionProcessor selectedToolChainOptionProcessor;
    private final Map<String, List<IProjectType>> projectTypeCache = new HashMap<String, List<IProjectType>>();
    private boolean initialState = true;
    private boolean createLaunchConfiguration = true;
    private String debugConfigurationName;

    public ProjectInfoImportSettings(Lingvo piDictionary) {
        this.lingvo = piDictionary;
        if (Realm.getDefault() != null) {
            this.piReaderWV = WritableValue.withValueType(PIReader.class);
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.initialState = false;
        this.projectName = projectName;
    }

    public PIReader getPiReader() {
        if (this.piReaderWV == null) {
            return this.piReader;
        }
        if (!this.piReaderWV.getRealm().equals(Realm.getDefault())) {
            return (PIReader)this.piReaderWV.doGetValue();
        }
        return (PIReader)this.piReaderWV.getValue();
    }

    public void setPiReader(PIReader piReader) {
        this.initialState = false;
        if (this.piReaderWV == null || !this.piReaderWV.getRealm().equals(Realm.getDefault())) {
            this.piReader = piReader;
        } else {
            this.piReaderWV.setValue((Object)piReader);
        }
    }

    public List<IProjectType> getProjectTypes() {
        return this.getProjectTypes("");
    }

    public WritableValue<Object> getPIReaderWritableValue() {
        return this.piReaderWV;
    }

    public List<IProjectType> getProjectTypes(String filter) {
        String coreSet;
        if (this.getPiReader() == null) {
            return Collections.emptyList();
        }
        String piDeviceId = this.getPiReader().getDeviceId();
        String s32dsDeviceId = this.getLingvo().mapToS32DS(piDeviceId, PI_DEVICE);
        String piCoreSet = this.getPiReader().getCoreSet();
        String s32dsCoreSet = this.getLingvo().mapToS32DS(piCoreSet, PI_CORESET);
        String deviceId = s32dsDeviceId == null ? piDeviceId : s32dsDeviceId;
        String string = coreSet = s32dsCoreSet == null ? piCoreSet : s32dsCoreSet;
        if (filter.length() > 0) {
            return this.getProjectTypesFor(deviceId, coreSet).stream().filter(e -> e.getId().contains(filter)).collect(Collectors.toList());
        }
        return this.getProjectTypesFor(deviceId, coreSet);
    }

    public String mapToS32DSdevice() {
        return this.getLingvo().mapToS32DS(this.getPiReader().getDeviceId(), PI_DEVICE);
    }

    public String mapToS32DScore() {
        return this.getLingvo().mapToS32DS(this.getPiReader().getCoreSet(), PI_CORESET);
    }

    private synchronized List<IProjectType> getProjectTypesFor(String s32dsProcessor, String s32dsCore) {
        if (Objects.isNull(s32dsProcessor) || Objects.isNull(s32dsCore)) {
            return Collections.emptyList();
        }
        String key = String.valueOf(s32dsProcessor) + 'x' + s32dsCore;
        if (this.projectTypeCache.containsKey(key)) {
            return this.projectTypeCache.get(key);
        }
        List<IProjectType> result = this.findProjectTypes(this.findCores(s32dsProcessor, s32dsCore));
        this.projectTypeCache.put(key, result);
        return result;
    }

    private List<IProjectType> findProjectTypes(List<CoreData> cores) {
        List templateIds = cores.stream().map(CoreNatureData::getTemplates).flatMap(Collection::stream).flatMap(t -> Stream.of(t.getExecutableTemplateId(), t.getLibraryTemplateId())).collect(Collectors.toList());
        return templateIds.stream().map(ProjectInfoImportSettings::getProjectTypesFromTemplateId).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public static List<IProjectType> getProjectTypesFromTemplateId(String templateId) {
        ArrayList<IProjectType> result = new ArrayList<IProjectType>();
        Template[] templateArray = TemplateEngineUI.getDefault().getTemplates();
        int n = templateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Template t = templateArray[n2];
            if (t.getTemplateInfo().getTemplateId().equals(templateId)) {
                String pts = t.getTemplateInfo().getProjectType();
                result.addAll(ProjectInfoImportSettings.getProjectType(pts));
            }
            ++n2;
        }
        return result;
    }

    private List<CoreData> findCores(String s32dsProcessor, String s32dsCore) {
        List procs = S32DSWizardPiPlugin.getFromHWModel(HWModel::getProcessors, p -> s32dsProcessor.equals(p.getId())).collect(Collectors.toList());
        if (!procs.isEmpty()) {
            return s32dsCore.equalsIgnoreCase("e200") ? procs.stream().map(ProcessorData::getCores).flatMap(Collection::stream).collect(Collectors.toList()) : procs.stream().map(ProcessorData::getCores).flatMap(Collection::stream).filter(c -> s32dsCore.equals(c.getCoreKindId())).collect(Collectors.toList());
        }
        return S32DSWizardPiPlugin.getFromHWModel(HWModel::getCores, c -> s32dsCore.equals(c.getCoreKindId())).collect(Collectors.toList());
    }

    public void setSelectedProjectType(IProjectType selectedProjectType) {
        this.selectedProjectType = selectedProjectType;
    }

    public IProjectType getSelectedProjectType() {
        if (this.selectedProjectType != null) {
            return this.selectedProjectType;
        }
        this.selectedProjectType = this.getProjectTypes().stream().findFirst().orElse(null);
        return this.selectedProjectType;
    }

    public static List<IProjectType> getProjectType(String id) {
        IProjectType pt;
        ArrayList<IProjectType> result = new ArrayList<IProjectType>();
        IProjectType[] iProjectTypeArray = ManagedBuildManager.getDefinedProjectTypes();
        int n = iProjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            pt = iProjectTypeArray[n2];
            if (id.equals(pt.getId()) && !result.contains(pt)) {
                result.add(pt);
            }
            ++n2;
        }
        iProjectTypeArray = ManagedBuildManager.getDefinedProjectTypes();
        n = iProjectTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            pt = iProjectTypeArray[n2];
            if (pt.getBuildArtefactType() != null && id.equals(pt.getBuildArtefactType().getId()) && !result.contains(pt)) {
                result.add(pt);
            }
            ++n2;
        }
        if (result.isEmpty()) {
            S32DSWizardPiPlugin.logWarning(String.valueOf(id) + " has no projectType");
        }
        return result;
    }

    private static List<IOptionProcessor> createConverterList(IToolChain tc) {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.freescale.s32ds.cross.wizard.pi.piToolChainOptionProcessor");
        if (ep == null) {
            return Collections.emptyList();
        }
        ArrayList<IOptionProcessor> result = new ArrayList<IOptionProcessor>();
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ex = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ex.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement cfgE = iConfigurationElementArray[n4];
                IConfigurationElement[] iConfigurationElementArray2 = cfgE.getChildren(ATTR_TC);
                int n5 = iConfigurationElementArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    IConfigurationElement tcE = iConfigurationElementArray2[n6];
                    String tcId = tcE.getAttribute(ATTR_ID);
                    if (tcId.equals(tc.getId()) || tcId.equals(tc.getSuperClass().getId())) {
                        try {
                            IOptionProcessor proc = (IOptionProcessor)cfgE.createExecutableExtension(ATTR_CL);
                            result.add(proc);
                        }
                        catch (CoreException e) {
                            S32DSWizardPiPlugin.log(e);
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    public IOptionProcessor getSelectedToolChainOptionProcessor(IToolChain tc) {
        if (this.selectedToolChainOptionProcessor != null) {
            return this.selectedToolChainOptionProcessor;
        }
        return ProjectInfoImportSettings.createConverterList(tc).stream().findFirst().orElse(null);
    }

    public boolean isInitialState() {
        return this.initialState;
    }

    public Lingvo getLingvo() {
        return this.lingvo;
    }

    public String getDebugConfigurationName() {
        return this.debugConfigurationName;
    }

    public void setDebugConfigurationName(String debugConfigurationName) {
        this.debugConfigurationName = debugConfigurationName;
    }

    public boolean isCreateLaunchConfiguration() {
        return this.createLaunchConfiguration;
    }

    public void setCreateLaunchConfiguration(boolean createLaunchConfiguration) {
        this.createLaunchConfiguration = createLaunchConfiguration;
    }

    public boolean getCreateLaunchConfigurationStatus() {
        return this.createLaunchConfiguration && !this.isLibrarySelected(this.getSelectedProjectType());
    }

    public boolean isLibrarySelected(IProjectType p) {
        return p.getId().endsWith(".lib") || p.getId().startsWith("iar.arm.toolchain.project.library");
    }
}

