/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core.utils;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MergeFPDevices {
    private static final String XML_DEVICE_TAG = "device";
    private static final String XML_NAME_TAG = "name";

    public static int mergeXMLFiles(File baseXML, File extraXML) {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transFormer = transFactory.newTransformer();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document baseDoc = builder.parse(baseXML);
            baseDoc.getDocumentElement().normalize();
            Document extraDoc = builder.parse(extraXML);
            extraDoc.getDocumentElement().normalize();
            MergeFPDevices.mergeNodesFPDevices(baseDoc, extraDoc);
            baseDoc.normalize();
            DOMSource source = new DOMSource(baseDoc);
            StreamResult dest = new StreamResult(baseXML);
            transFormer.transform(source, dest);
        }
        catch (Exception exception) {
            return 0;
        }
        return 1;
    }

    private static void mergeNodesFPDevices(Document baseDoc, Document extraDoc) {
        NodeList nodeBaseLst = baseDoc.getElementsByTagName(XML_DEVICE_TAG);
        NodeList nodeExtraLst = extraDoc.getElementsByTagName(XML_DEVICE_TAG);
        NodeList baseChildList = nodeBaseLst.item(0).getChildNodes();
        NodeList extraChildList = nodeExtraLst.item(0).getChildNodes();
        ArrayList<Node> newNodes = new ArrayList<Node>();
        Element baseDocElmnt = (Element)nodeBaseLst.item(0);
        int s = 0;
        while (s < extraChildList.getLength()) {
            Node migratingChild;
            if (extraChildList.item(s).getNodeType() == 1 && !MergeFPDevices.findDuplicateNode(migratingChild = extraChildList.item(s), baseChildList, XML_NAME_TAG)) {
                migratingChild = baseDoc.importNode(migratingChild, true);
                newNodes.add(migratingChild);
            }
            ++s;
        }
        for (Node node : newNodes) {
            baseDocElmnt.appendChild(node);
        }
    }

    private static String getNodeName(Node xmlNode, String tagName) {
        String nodeName = "";
        Element xmlNodeElmnt = (Element)xmlNode;
        NodeList childNodes = xmlNodeElmnt.getChildNodes();
        int s = 0;
        while (s < childNodes.getLength()) {
            Node fstNode = childNodes.item(s);
            if (fstNode.getNodeType() == 1 && fstNode.getNodeName() == tagName) {
                NodeList nameList = fstNode.getChildNodes();
                nodeName = nameList.item(0).getNodeValue();
                return nodeName;
            }
            ++s;
        }
        return nodeName;
    }

    private static boolean findDuplicateNode(Node searchNode, NodeList origNodeList, String tagName) {
        String searchNodeName = MergeFPDevices.getNodeName(searchNode, tagName);
        int k = 0;
        while (k < origNodeList.getLength()) {
            if (origNodeList.item(k).getNodeType() == 1 && MergeFPDevices.getNodeName(origNodeList.item(k), tagName).compareToIgnoreCase(searchNodeName) == 0) {
                return true;
            }
            ++k;
        }
        return false;
    }
}

