/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.internal.errorparsers;

import com.freescale.s32ds.cdt.core.ICompilationPathResolver;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class CompilationPathResolverManager {
    private static final String EXTENSION_POINT_COMPILATION_PATH_RESOLVER = "CompilationPathResolver";
    private static final String ELEM_RESOLVER = "resolver";
    private static final String ATTR_CLASS = "class";
    private static ArrayList<ICompilationPathResolver> fResolvers = new ArrayList();

    static {
        CompilationPathResolverManager.loadExtensions();
    }

    public static synchronized void loadExtensions() {
        fResolvers.clear();
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", EXTENSION_POINT_COMPILATION_PATH_RESOLVER);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                try {
                    IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICompilationPathResolver resolver;
                        IConfigurationElement cfgEl = iConfigurationElementArray[n4];
                        if (cfgEl.getName().equals(ELEM_RESOLVER) && cfgEl.getAttribute(ATTR_CLASS) != null && (resolver = (ICompilationPathResolver)cfgEl.createExecutableExtension(ATTR_CLASS)) != null) {
                            fResolvers.add(resolver);
                        }
                        ++n4;
                    }
                }
                catch (Exception e) {
                    CCorePlugin.log((String)("Cannot load CompilationPathResolver extension " + ext.getUniqueIdentifier()), (Throwable)e);
                }
                ++n2;
            }
        }
    }

    public static ICompilationPathResolver[] getResolvers() {
        return fResolvers.toArray(new ICompilationPathResolver[0]);
    }
}

