/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk;

import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class SDKAttachListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IResource resource = event.getResource();
        if (resource instanceof IProject && resource != null) {
            try {
                resource.accept((IResourceVisitor)new ProjectVisitor());
            }
            catch (CoreException ce) {
                SDKSupportPlugin.log(ce.getMessage());
            }
        }
    }

    class ProjectVisitor
    implements IResourceVisitor {
        ProjectVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            SDKAttachValidateJob job = new SDKAttachValidateJob("sdk_attach_validate_job", (IProject)resource);
            job.setRule((ISchedulingRule)resource);
            job.schedule();
            return false;
        }
    }

    class SDKAttachValidateJob
    extends WorkspaceJob {
        private IProject project;

        public SDKAttachValidateJob(String name, IProject project) {
            super(name);
            this.project = project;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            SDKAttach.getAttached(this.project, true);
            return Status.OK_STATUS;
        }
    }
}

