/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.ISDKFilesChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.ISDKFilesCheckerResult;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.SDKConflictedFilesChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.SDKFilesCheckerResult;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.SDKMissedFilesChecker;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public abstract class SDKFilesChecker
implements ISDKFilesChecker {
    private final ISDK sdk;
    private final IPath sdkPath;
    private final IFolder sdkFolder;
    private final IProject project;
    private static Map<String, Set<String>> sdkCheckDone = new HashMap<String, Set<String>>();

    protected SDKFilesChecker(ISDK sdk, IProject project) {
        this.sdk = Objects.requireNonNull(sdk, "SDK must not be null");
        this.project = Objects.requireNonNull(project, "Project must not be null");
        this.sdkPath = SDKSupportPlugin.getEclipsePath(sdk);
        this.sdkFolder = project.getFolder(sdk.getName());
    }

    public static ISDKFilesChecker getFilesChecker(ISDK sdk, IProject project, ISDKFilesChecker.Mode mode) {
        switch (mode) {
            case MISSED: {
                return new SDKMissedFilesChecker(sdk, project);
            }
            case CONFLICTED: {
                return new SDKConflictedFilesChecker(sdk, project);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ISDKFilesCheckerResult checkFiles() {
        SDKFilesCheckerResult result = new SDKFilesCheckerResult();
        result.setResultFiles(this.findFiles(this.collectSDKFiles()));
        return result;
    }

    @Override
    public void setCheckDone(boolean isDone) {
        Set<String> sdks = sdkCheckDone.get(this.project.getName());
        if (isDone) {
            if (sdks == null) {
                sdks = new HashSet<String>();
            }
            sdks.add(this.sdk.getId());
            sdkCheckDone.put(this.project.getName(), sdks);
        } else if (sdks != null) {
            sdks.remove(this.sdk.getId());
            if (sdks.isEmpty()) {
                sdkCheckDone.remove(this.project.getName());
            }
        }
    }

    @Override
    public boolean isCheckDone() {
        Set<String> sdks = sdkCheckDone.get(this.project.getName());
        return sdks != null && sdks.contains(this.sdk.getId());
    }

    protected abstract boolean checkFile(IFile var1);

    protected boolean checkPathAndType(IExtendedPath path, ISDKFilesChecker.FileTypes type) {
        return true;
    }

    private Map<ISDKFilesChecker.FileTypes, List<IExtendedPath>> collectSDKFiles() {
        String toolchainId = ManagedBuildManager.getBuildInfo((IResource)this.project).getDefaultConfiguration().getToolChain().getBaseId();
        LinkedHashMap<ISDKFilesChecker.FileTypes, List<IExtendedPath>> sdkFiles = new LinkedHashMap<ISDKFilesChecker.FileTypes, List<IExtendedPath>>();
        sdkFiles.put(ISDKFilesChecker.FileTypes.SOURCE, Arrays.asList(this.sdk.getSources(toolchainId)));
        sdkFiles.put(ISDKFilesChecker.FileTypes.HEADER, Arrays.asList(this.sdk.getHeaders(toolchainId)));
        sdkFiles.put(ISDKFilesChecker.FileTypes.BINARY, Arrays.asList(this.sdk.getBinaries(toolchainId)));
        sdkFiles.put(ISDKFilesChecker.FileTypes.LINKER, Arrays.asList(this.sdk.getLinkerFiles(toolchainId)));
        sdkFiles.put(ISDKFilesChecker.FileTypes.OTHERS, Arrays.asList(this.sdk.getOtherResources(toolchainId)));
        return sdkFiles;
    }

    private Set<IExtendedPath> findFiles(Map<ISDKFilesChecker.FileTypes, List<IExtendedPath>> pathMap) {
        LinkedHashSet<IExtendedPath> foundFiles = new LinkedHashSet<IExtendedPath>();
        pathMap.forEach((type, pathes) -> pathes.stream().filter(path -> this.performCheck((IExtendedPath)path, (ISDKFilesChecker.FileTypes)((Object)type))).forEach(path -> {
            boolean bl = foundFiles.add((IExtendedPath)path);
        }));
        return foundFiles;
    }

    private boolean performCheck(IExtendedPath path, ISDKFilesChecker.FileTypes type) {
        boolean result = false;
        if (!path.toFile().isDirectory() && this.checkPathAndType(path, type)) {
            IFile file = this.getFileToCheck(path);
            return file != null && this.checkFile(file);
        }
        return result;
    }

    private IFile getFileToCheck(IExtendedPath p) {
        IFile file = null;
        String copyPath = p.copyPath();
        String renameTo = p.renameTo();
        if (this.isRoot(copyPath)) {
            file = renameTo != null && !renameTo.isEmpty() ? this.project.getFile(renameTo) : this.project.getFile(p.lastSegment());
        } else {
            IPath srcRelPath = p.makeRelativeTo(this.sdkPath);
            IFolder folder = this.getFolder(copyPath, srcRelPath);
            if (folder != null && srcRelPath.lastSegment() != null) {
                file = renameTo != null && !renameTo.isEmpty() ? folder.getFile(renameTo) : folder.getFile(srcRelPath.lastSegment());
            }
        }
        return file;
    }

    private boolean isRoot(String copyPath) {
        return copyPath != null && (copyPath.isEmpty() || copyPath.equals(".") || copyPath.equals("/"));
    }

    private IFolder getFolder(String copyPath, IPath srcRelPath) {
        IFolder folder;
        if (copyPath == null) {
            folder = this.sdkFolder;
            int i = 0;
            while (i < srcRelPath.segmentCount() - 1) {
                folder = folder.getFolder(srcRelPath.segment(i));
                ++i;
            }
        } else {
            folder = this.project.getFolder(copyPath);
        }
        return folder;
    }
}

