/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.IContributedSDK;
import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKHook;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.internal.AbstractSDK;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.GitSDK;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.hook.SDKHookHandler;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ContributedSDK
extends AbstractSDK
implements IContributedSDK {
    public static final String HOOK_ATTRIBUTE_TAG = "hook";
    private final String[] tcIds;
    private final String[] aliases;

    public ContributedSDK(SDKHeader head, TCHolder root, IFilterOptions filterOptions, TCHolder[] tcHolder) {
        super(head, root, filterOptions, tcHolder);
        this.toolchains = tcHolder;
        this.tcIds = this.getIds(root, tcHolder);
        this.aliases = ContributedSDK.getFields(tcHolder, 1);
        this.type = ISDK.TYPE.CONTRIBUTED;
    }

    @Override
    public ISDK.STATUS getStatus() {
        return ISDK.STATUS.CONTR;
    }

    public static void loadContributedSDKs() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.freescale.s32ds.cross.sdk.support.sdks");
        if (ep != null) {
            IExtension[] exts;
            IExtension[] iExtensionArray = exts = ep.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                try {
                    IConfigurationElement[] ces;
                    Bundle bundle = Platform.getBundle((String)ext.getContributor().getName());
                    IConfigurationElement[] iConfigurationElementArray = ces = ext.getConfigurationElements();
                    int n3 = ces.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement ce = iConfigurationElementArray[n4];
                        String element = ce.getName();
                        if (element.equals("sdk")) {
                            SDKHeader head = new SDKHeader(ce);
                            ISDKHook localhook = null;
                            if (ce.getAttribute(HOOK_ATTRIBUTE_TAG) != null) {
                                try {
                                    localhook = (ISDKHook)ce.createExecutableExtension(HOOK_ATTRIBUTE_TAG);
                                }
                                catch (CoreException e) {
                                    SDKSupportPlugin.error(e);
                                }
                            }
                            if (localhook != null) {
                                try {
                                    localhook.stateChange(257, null, head.getId(), head.getBasePath());
                                }
                                catch (Throwable e) {
                                    SDKSupportPlugin.error("Error calling PRE_LOAD hook", e);
                                }
                            }
                            ContributedSDK sdk = null;
                            String p = null;
                            if (head.isGit()) {
                                sdk = new GitSDK(head);
                                SDKHookHandler.INSTANCE.registerSDKHook(sdk, localhook);
                                p = head.gitpath;
                            } else {
                                head.setEnv(SDKSupportPlugin.createEnvironment(head.getName(), head.getVersion(), false, true, head.getBasePath(), head.getDescription()));
                                String fullPath = head.isInternal() ? ContributedSDK.createFullPathFromInternal(bundle, head.getBasePath()) : head.getBasePath();
                                IPath sdkRootPath = Path.fromOSString((String)SDKSupportPlugin.performStringSubstitution(fullPath, head.getName()));
                                TCHolder root = new TCHolder(ce, sdkRootPath);
                                IConfigurationElement[] tces = ce.getChildren("toolchain");
                                TCHolder[] tchs = new TCHolder[tces.length];
                                StringBuilder sb = new StringBuilder();
                                int i = 0;
                                while (i < tces.length) {
                                    tchs[i] = new TCHolder(tces[i], sdkRootPath);
                                    if (sb.length() > 0) {
                                        sb.append(",");
                                    }
                                    sb.append(tchs[i].getTCId());
                                    ++i;
                                }
                                String tc = sb.length() > 0 ? sb.toString() : head.getObsoleteToolchainIds();
                                IFilterOptions filterOptions = FilterOptions.createFilterOptions(head.getLangs(), tc, head.getCores());
                                sdk = new ContributedSDK(head, root, filterOptions, tchs);
                                SDKHookHandler.INSTANCE.registerSDKHook(sdk, localhook);
                                p = sdkRootPath.toOSString();
                            }
                            if (sdk != null) {
                                sdk.stateChange(1, true, null, p);
                                SDKUtils.add(sdk, false);
                            }
                        }
                        ++n4;
                    }
                }
                catch (IOException | CoreException e) {
                    SDKSupportPlugin.error(e);
                }
                ++n2;
            }
        }
    }

    private static String createFullPathFromInternal(Bundle bundle, String basePath) throws IOException, CoreException {
        URL url = bundle.getEntry("/");
        String pathStr = String.format("%s/%s", FileLocator.resolve((URL)url).getPath(), basePath);
        IEnvironment en = SDKSupportPlugin.getEnvironment("eclipse_home");
        if (en.exists()) {
            IPath eclipseHome = Path.fromOSString((String)en.getValue());
            IPath path = Path.fromOSString((String)pathStr).makeRelativeTo(eclipseHome);
            pathStr = String.valueOf(en.getName()) + path.toString();
        }
        return pathStr;
    }

    @Override
    public String[] getToolChainIDs() {
        return this.tcIds;
    }

    @Override
    public String[] getToolChainAliases() {
        return this.aliases;
    }

    private String[] getIds(TCHolder root, TCHolder[] hs) {
        String[] res = ContributedSDK.getFields(hs, 0);
        if (res.length > 0) {
            return res;
        }
        String id = root.getTCId();
        if (id == null || id.isEmpty()) {
            String obsoleteToolchainIds = this.head.getObsoleteToolchainIds();
            return obsoleteToolchainIds == null ? ZERO_ARR : obsoleteToolchainIds.split(",");
        }
        return new String[]{id};
    }

    @Override
    public IExtendedPath[][] getAll(int mode) {
        IExtendedPath[][] res = new IExtendedPath[this.tcIds.length + 1][0];
        res[0] = this.union(this.root, this.toolchains, mode, "all_toolchains");
        int i = 0;
        while (i < this.tcIds.length) {
            res[i + 1] = this.union(this.root, this.toolchains, mode, this.tcIds[i]);
            ++i;
        }
        return res;
    }

    @Override
    public String[][] getDefSymbols() {
        if (this.tcIds != null && this.tcIds.length > 0) {
            String[][] res = new String[this.tcIds.length][];
            int i = 0;
            while (i < this.tcIds.length) {
                res[i] = this.getDefSymbols(this.tcIds[i]);
                ++i;
            }
            return res;
        }
        String[][] res = new String[][]{this.getDefSymbols("all_toolchains")};
        return res;
    }

    @Override
    public IStatus checkStateChangePreconditions(int mode, Map<String, Object> context) {
        return SDKHookHandler.INSTANCE.checkExecutePreconditions(this, mode, context);
    }

    @Override
    public void stateChange(int mode, boolean after, Object cfg, String path) {
        SDKHookHandler.INSTANCE.execute(this, mode, after, cfg, path);
    }

    @Override
    public IStatus checkStateChangePostconditions(int mode, Map<String, Object> context) {
        return SDKHookHandler.INSTANCE.checkExecutePostconditions(this, mode, context);
    }
}

