/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKHook;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class S32DSTester
extends PropertyTester
implements ISDKHook {
    private static final String KEY_PREF = "checkS32DS";
    private static final String S32_PREF = "/.settings/com.freescale.s32ds.cross.core.prefs";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (KEY_PREF.equals(property)) {
            return S32DSTester.checkProjectType(receiver);
        }
        return false;
    }

    public static boolean checkProjectType(Object receiver) {
        if (receiver instanceof IProject) {
            return ((IProject)receiver).getLocation().append(S32_PREF).toFile().exists();
        }
        return false;
    }

    public static boolean checkCNature(Object receiver) {
        IProject p;
        if (receiver instanceof IProject && (p = (IProject)receiver).isOpen()) {
            try {
                return p.hasNature("org.eclipse.cdt.core.cnature") || p.hasNature("org.eclipse.cdt.core.ccnature");
            }
            catch (CoreException e) {
                SDKSupportPlugin.error(e);
            }
        }
        return false;
    }

    @Override
    public void stateChange(int mode, ISDK sdk, Object cfg, String path) {
        int n = mode & 0xF;
        if (n > 4) {
            n = 0;
        }
        String s = String.valueOf(ISDKHook.STATES[n]) + '_' + ((mode & 0x200) != 0 ? "AFTER" : "BEFORE");
        SDKSupportPlugin.log(String.format("Called SDK hook, mode=%s, SDK=%s, CFG=%s, PATH=%s", s, sdk, cfg, path));
    }
}

